// ---------------------------------------------------------------------------
// - Freeable.hpp                                                            -
// - standard object library - freeable abstract class definition            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_FREEABLE_HPP
#define  AFNIX_FREEABLE_HPP

#ifndef  AFNIX_OBJECT_HPP
#include "Object.hpp"
#endif

namespace afnix {

  /// The Freeable class is an abstract class designed to provide the
  /// 'release' method. when the method is invoked, all objects that have
  /// a link susceptible to create loop and thus preventing the object
  /// destruction, are supposed to release such link. Releasing a link do
  /// not necessarily result in the object destruction.
  /// @author amaury darsch

  class Freeable : public virtual Object  {
  public:
    /// release the object links
    virtual void release (void) = 0;

  public:
    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
