// ---------------------------------------------------------------------------
// - t_md5.cpp                                                               -
// - afnix cryptography - md5 class tester module                            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Md5.hpp"

int main (int, char**) {
  using namespace afnix;

  // create a MD5 message digest
  Md5 md;
  if (md.getname () != "MD-5") return 1;

  // check digest as specified in RFC 1321
  String digest = md.compute ("");
  if (digest != "D41D8CD98F00B204E9800998ECF8427E") return 1;
  digest = md.compute ("a");
  if (digest != "0CC175B9C0F1B6A831C399E269772661") return 1;
  digest = md.compute ("abc");
  if (digest != "900150983CD24FB0D6963F7D28E17F72") return 1;
  digest = md.compute ("message digest");
  if (digest != "F96B697D7CB7938D525A2F31AAF161D0") return 1;
  digest = md.compute ("abcdefghijklmnopqrstuvwxyz");
  if (digest != "C3FCD3D76192E4007DFB496CCA67E13B") return 1;
  digest = md.compute ("ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                       "abcdefghijklmnopqrstuvwxyz"
                       "0123456789");
  if (digest != "D174AB98D277D9F5A5611C2C9F419D9F") return 1;
  digest = md.compute ("123456789012345678901234567890"
                       "123456789012345678901234567890"
                       "12345678901234567890");
  if (digest != "57EDF4A22BE3C955AC49DA2E2107B67A") return 1;

  // the afnix test as usual
  digest = md.compute ("afnix");
  if (digest != "A8EB13C9B587895548E1E14AD7CDF7AA") return 1;
  digest = md.compute ("afnix programming language");
  if (digest != "564DEBD9253673DBFB8C0D5BC26273EE") return 1;

  // success
  return 0;
}
