// ---------------------------------------------------------------------------
// - Persist.hpp                                                             -
// - afnix:sps module - persist class definition                             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_PERSIST_HPP
#define  AFNIX_PERSIST_HPP

#ifndef  AFNIX_SERIAL_HPP
#include "Serial.hpp"
#endif

namespace afnix {

  /// The Persist class is a base class for the afnix spreadsheet module. 
  /// The class defines the  methods that are used to read of write 
  /// a particular persistent object. When saving, the object name is 
  /// retreived with the get name method. The saveas method does the same as 
  /// save but takes a file name argument.
  /// @author amaury darsch

  class Persist : public Serial {
  public:
    /// @return the persist name
    virtual String getname (void) const =0;

    /// save the persistent object to a file
    virtual void save (void) const;

    /// save the persistent object by name
    virtual void saveas (const String& name) const;    

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);
  };
}

#endif
