//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_DIALOGS_ALBUMSTATISTICS_H
#define GUI_DIALOGS_ALBUMSTATISTICS_H

#include <qdialog.h>

//forward declarations
class QGridLayout;
class QFrame;
class QLabel;
class QPixmap;
class QPushButton;
class Album;

//=====================================
/*! \brief Album Statistics Window
 */
//=====================================

//======================
class AlbumStatistics : public QDialog
{
Q_OBJECT
//----------------------
public:
  AlbumStatistics( Album* album, QWidget *parent=0, const char* name=0);
//----------------------
signals:
  void closed();
//----------------------
private slots:
  void setCreationDate();
  void reject();
//----------------------
private:
  void closeEvent( QCloseEvent* e);

  Album* album;
  QGridLayout* grid;
  QGridLayout* grid2;

  QLabel* titleMessage;

  QLabel* numSubalbums;
  QLabel* numSubalbumsVal;

  QLabel* numPhotos;
  QLabel* numPhotosVal;

  QLabel* sizeOnDisk;
  QLabel* sizeOnDiskVal;

  QLabel* created;
  QLabel* createdVal;
  QPushButton* setCreatedVal;

  QLabel* modified;
  QLabel* modifiedVal;

  QFrame* albumPreview;
  QPixmap* albumImage;
  QLabel* albumIcon;

  QLabel* albumTitle;

  ///Close button
  QPushButton* closeButton;
//----------------------
};
//======================

#endif //GUI_DIALOGS_ALBUMSTATISTICS_H
