//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_HELP_CONTENTS_H
#define GUI_HELP_CONTENTS_H

#include <qtextbrowser.h>
#include <qsize.h>
#include <qtextstream.h>

//=====================================
/*! \brief Contents window widget
 */
//=====================================

///page selected
typedef enum
{  
  BILLBOARD,
  WHATS_NEW,
  IMPORTING_AND_ORGANIZING,
  ANNOTATING_ALBUMS,
  FRAMING,
  ENHANCING,
  PRO_TOOLS,
  MANIPULATING,
  SAVING_AND_LOADING,
  KEYBOARD_SHORTCUTS,
  INVALID,
} HELP_PAGE;

//======================
class Contents : public QTextBrowser
{
Q_OBJECT
  //----------------------
public:
  Contents( QTextStream::Encoding type, 
            QString saveCharSet, QMimeSourceFactory* loadingMimeSource,
            QWidget *parent=0, const char* name=0);
  
  QSize minimumSizeHint() const;
  //----------------------
private:
  QSize optimalSize;
  QString filename();
  void generateHTML(QTextStream::Encoding type, QString charSet);
  void printLink( QTextStream& stream, QString text, HELP_PAGE anchor, QString anchorString );
  HELP_PAGE currentPage;
  
  QTextStream::Encoding type;
  QString saveCharSet;
  //----------------------
signals:
  void setPage(HELP_PAGE page);
  //----------------------
private slots:  
  void handleAnchorClick(const QString &name, const QString &link);
//----------------------
};
//======================

#endif //GUI_HELP_CONTENTS_H
