//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_SUBALBUMPREVIEWWIDGET_H
#define GUI_SUBALBUMPREVIEWWIDGET_H

//--------------------
//forward declarations
class Subalbum;
class QPixmap;
class QString;
class SubalbumsIconView;
//--------------------

#include <qiconview.h>
#include <qobject.h>

//=====================================
/*! \brief Displays subalbum icon and name.
 */
//=====================================
class SubalbumPreviewWidget : public QIconViewItem
{
public:
  ///Sets subalbum pointer
  SubalbumPreviewWidget( SubalbumsIconView* parent,
                         Subalbum* salbum );

  ///Returns subalbum pointer
  Subalbum* getSubalbum();

  void paintFocus( QPainter *p, const QColorGroup &cg );

  bool acceptDrop( const QMimeSource *e) const;

  int compare ( QIconViewItem * i ) const;

  static QPixmap* createSubalbumPixmap( QString imageName );

  void setText ( const QString & text );
  void setMousedOver(bool val);
  void paint( QPainter *p );
//----------------------
protected:
  void calcRect ( const QString & text_ = QString::null );    
  void paintItem( QPainter* p,
                  const QColorGroup& cg);
//----------------------
private:
  void dropped( QDropEvent *e, const QValueList<QIconDragItem> &lst );

  QColor blendColors( QColor a, QColor b, double alpha);

  ///Pointer to subalbum backend object
  Subalbum* subalbum;

  ///Representative Image for Subalbum
  QPixmap* subalbumPreviewImage;

  ///Subalbum's Name
  QString* subalbumName;

  ///parent icon view
  SubalbumsIconView* parent;

  ///is the mouse over the widget
  bool mousedOver;  
  
  //initializes item rect size
  void initializeItemRect();
//----------------------
};
//======================

#endif //GUI_SUBALBUMPREVIEWWIDGET_H
