<?xml version="1.0" encoding="iso-8859-1"?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <title>Editer des mathmatiques</title>
  <meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
  <link href="style.css" rel="stylesheet" type="text/css" />
</head>

<body xml:lang="fr" lang="fr">

<div>
<img alt="Amaya" src="../../resources/icons/22x22/logo.png" class="logo" /> 

<p class="nav"><a href="ImageMaps.html.fr" accesskey="p"><img alt="previous"
src="../../resources/icons/misc/left.png" /></a> <a href="Manual.html.fr"
accesskey="t"><img alt="top" src="../../resources/icons/misc/up.png" /></a>
<a href="SVG.html.fr" accesskey="n"><img alt="next"
src="../../resources/icons/misc/right.png" /></a></p>
</div>

<div id="page_body">
<h2>Editer des mathmatiques</h2>

<p>La possibilit d'inclure des expressions mathmatiques est vraiment
importante pour les scientifiques. Certains formats informatiques, tels que
LaTeX, le permettent dj pour les documents dont le but est d'tre rendus de
faon visuelle, en particulier d'tre imprime. Nanmoins, l'inclusion de
formules mathmatiques dans les pages web est beaucoup plus difficile. On
utilise gnralement des images produites  partir de sources LaTeX : on
obtient un temps de chargement plus long, une mise en page inadapte au texte
environnant, une mauvaise qualit d'impression... De plus, Internet est cens
tre un moyen universel de partage de l'information et un language plus
puissant que LaTeX est requis pour que les formules soient comprhensibles
par des synthtiseurs vocaux (pour les malvoyants), des logiciels
mathmatiques, des moteurs de recherche...</p>

<p>Pour toutes ces raisons, le W3C a cr le <a
href="http://www.w3.org/TR/MathML2/">MathML</a> (Mathematical Markup
Language) et indique que, du fait de sa complexit, il ne devrait pas tre
dit  la main. Par consquent, Amaya propose une interface Wysiwyg o les
expressions mathmatiques sont traites comme des composants structurs, de
la mme manire que les lments HTML. Vous pouvez donc manipuler les
expressions mathmatiques comme vous manipulez les autres parties des
documents HTML. Toutes les commandes d'dition fournies par Amaya pour
traiter le texte sont galement utilisables pour les mathmatiques. Il y a
quelques manipulations supplmentaires pour entrer des constructions
mathmatiques. Notez que les diffrents navigateurs ne se comportent pas de
la mme manire envers le MathML : regardez la section sur la <a
href="#Compatib">compatibilit des navigateurs</a> pour plus
d'informations.</p>

<h3>Crer une formule mathmatique</h3>

<h4 id="Nouvelle">Nouvelle formule</h4>

<p>Gnralement, les formules mathmatiques ne sont pas isoles, mais
incluses dans un document avec du texte, des tableaux, des images... pour
cela vous devez crer un document XHTML. Sinon, vous pouvez crer un document
MathML (mml) par exemple pour utiliser les formules dans d'autres
logiciels.</p>

<p>Pour crer une expression mathmatique dans un document, il suffit de <a
href="Selecting.html.fr#Selecting">placer le point d'insertion</a> 
l'endroit o vous voulez insrer l'expression, puis de cliquer sur le bouton
<strong>Math</strong> (le premier bouton de la palette Math) ou de
slectionner l'entre <strong>Nouvelle formule</strong> du menu
<strong>XML</strong>. Voici des exemples avec une formule insre directement
dans le document XHTML ou  l'intrieur d'une image SVG :</p>

<p><math xmlns="http://www.w3.org/1998/Math/MathML">
  <mrow>
    <mi>&#x393;</mi>
    <mo>&#x2061;</mo>
    <mrow>
      <mo>(</mo>
      <mi>x</mi>
      <mo>)</mo>
    </mrow>
  </mrow>
  <mo>=</mo>
  <mrow>
    <msubsup>
      <mo>&#x222b;</mo>
      <mn>0</mn>
      <mrow>
        <mo>+</mo>
        <mi>&#x221e;</mi>
      </mrow>
    </msubsup>
    <msup>
      <mi>t</mi>
      <mrow>
        <mi>x</mi>
        <mo>&#x2212;</mo>
        <mn>1</mn>
      </mrow>
    </msup>
    <msup>
      <mi>&#x2147;</mi>
      <mrow>
        <mo>&#x2212;</mo>
        <mi>t</mi>
      </mrow>
    </msup>
    <mrow>
      <mo>&#x2146;</mo>
      <mi>t</mi>
    </mrow>
  </mrow>
</math></p>

<p><svg xmlns="http://www.w3.org/2000/svg" height="250">
  <g transform="matrix(0.707107,-0.707107,0.707107,0.707107,0,150)">
    <rect style="stroke:#50ff50;stroke-width:3px;fill:#aaffaa;" width="200"
          height="100"/>
    <path
          d="M 44.727272,21.090909 L 36.359858,29.587325 L 40.292606,40.845041 L 28.432844,39.600562 L 22.083235,49.69438 L 15.661767,39.646124 L 3.8111859,40.975193 L 7.6635087,29.689702 L -0.76431515,21.253205 L 10.460921,17.228684 L 11.802177,5.3794762 L 21.947495,11.646471 L 32.047838,5.3072476 L 33.473606,17.146584 L 44.727272,21.090909 z "
          transform="translate(150,40)"
          style="stroke:#ffaa00;stroke-width:1px;fill:#ffff00;"/>
    <path
          d="M 50.363636,43.81818 C 50.090154,43.025081 51.297791,43.058245 51.681818,43.363636 C 52.722508,44.191224 52.181922,45.777285 51.272725,46.454544 C 49.646384,47.666002 47.379434,46.796331 46.40909,45.181813 C 44.98507,42.812444 46.220462,39.785248 48.545459,38.545452 C 51.644314,36.892997 55.454153,38.507192 56.954547,41.545458 C 58.842639,45.368806 56.844001,49.970617 53.090902,51.727273 C 48.545397,53.854818 43.146815,51.468849 41.136361,46.999991 C 38.767111,41.733596 41.542078,35.535434 46.727281,33.272723 C 52.713804,30.660333 59.713334,33.825342 62.227275,39.727281 C 65.083776,46.433439 61.528027,54.235551 54.909079,57.000002 C 47.483621,60.101298 38.878068,56.15432 35.863632,48.818168 C 32.517038,40.673649 36.8556,31.26402 44.909104,27.999994"
          transform="translate(-5,30)"
          style="fill:none;stroke:#000000;stroke-width:1px;"/>
    <path
          d="M 43.454546 30.272728 A 16.454546 7.3636365 0 1 1  10.545454,30.272728 A 16.454546 7.3636365 0 1 1  43.454546 30.272728 z"
          style="stroke:#ff0000;stroke-width:3px;fill:#ffaaaa;"
          transform="translate(70,40)"/>
    <switch>
      <foreignObject requiredExtensions="http://www.w3.org/1998/Math/MathML">
        <math xmlns="http://www.w3.org/1998/Math/MathML">
          <mstyle mathcolor="#000080;">
            <mrow>
              <mi>&#x393;</mi>
              <mo>&#x2061;</mo>
              <mrow>
                <mo>(</mo>
                <mi>x</mi>
                <mo>)</mo>
              </mrow>
            </mrow>
            <mo>=</mo>
            <mrow>
              <msubsup>
                <mo>&#x222b;</mo>
                <mn>0</mn>
                <mrow>
                  <mo>+</mo>
                  <mi>&#x221e;</mi>
                </mrow>
              </msubsup>
              <msup>
                <mi>t</mi>
                <mrow>
                  <mi>x</mi>
                  <mo>&#x2212;</mo>
                  <mn>1</mn>
                </mrow>
              </msup>
              <msup>
                <mi>&#x2147;</mi>
                <mrow>
                  <mo>&#x2212;</mo>
                  <mi>t</mi>
                </mrow>
              </msup>
              <mrow>
                <mo>&#x2146;</mo>
                <mi>t</mi>
              </mrow>
            </mrow>
          </mstyle>
        </math> </foreignObject>
    </switch>
  </g>
</svg>
 </p>

<h4 id="XMLMenu">Le menu XML</h4>

<p>Le menu <strong>XML/Elments math de base</strong> contient des lments
non disponibles dans la palette. Les premiers lments crent un nouvel
lment d'un type donn  l'intrieur d'une expression mathmatique : Texte
(<code>mtext</code>), Identificateur (<code>mi</code>), Nombre
(<code>mn</code>), Oprateur (<code>mo</code>). Ces commandes peuvent aussi
changer le type d'un lment seul ou d'une squence d'lments.</p>

<p>La commande suivante, Espace (<code>mspace</code>), vous permet d'ajouter
un espace dans une formule. Pour changer sa taille, vous devez modifier
l'attribut <strong>width</strong>. Voir la section sur l'<a
href="#Espacement">Espacement</a>.</p>

<p>Ces lments sont suivis de la commande Caractre (<code>&amp;xxx;</code>)
qui vous permet d'entrer un caractre qui n'est pas disponible sur le
clavier. Elle affiche une bote de dialogue dans laquelle vous devez entrer
le nom du caractre (par exemple <code>alpha</code> pour le caractre grec
&#x3b1;).</p>

<p>Les deux dernires commandes InvisibleTimes and ApplyFunction sont
utiliss pour entrer les caractres invisibles correspondants. Voir la
section sur les <a href="#Speciaux">caractres spciaux</a>.</p>

<p>Le menu <strong>XML/Constructions math</strong> vous permet de crer de
nouvelles constructions  l'intrieur d'une formule. Si le point d'insertion
n'est pas dans une formule, un lment Math est d'abord cr pour accepter la
nouvelle construction. Les constructions disponibles sont:</p>
<ul>
  <li>Racine (<code>mroot</code> dans MathML) : <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <mroot>
        <mrow>
          <mi>x</mi>
          <mo>+</mo>
          <mn>1</mn>
        </mrow>
        <mn>3</mn>
      </mroot>
    </math></li>
  <li>Racine carre ( <code>msqrt)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <msqrt>
        <mrow>
          <mi>x</mi>
          <mo>+</mo>
          <mn>1</mn>
        </mrow>
      </msqrt>
    </math></li>
  <li>Englobe (<code>menclose)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <menclose>
        <mn>1234</mn>
      </menclose>
    </math></li>
  <li>Fraction (<code>mfrac)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <mfrac>
        <mn>1</mn>
        <mrow>
          <mi>x</mi>
          <mo>+</mo>
          <mn>1</mn>
        </mrow>
      </mfrac>
    </math></li>
  <li>Indice et exposant Expression (<code>msubsup)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <msubsup>
        <mi>x</mi>
        <mrow>
          <mi>i</mi>
          <mo>+</mo>
          <mn>1</mn>
        </mrow>
        <mi>n</mi>
      </msubsup>
    </math> ou <math xmlns="http://www.w3.org/1998/Math/MathML">
      <mrow>
        <msubsup>
          <mo>&#x222b;</mo>
          <mn>0</mn>
          <mo>&#x221e;</mo>
        </msubsup>
      </mrow>
    </math></li>
  <li>Indice (<code>msub)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <msub>
        <mi>x</mi>
        <mi>i</mi>
      </msub>
    </math></li>
  <li>Exposant (<code>msup)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <msup>
        <mi>x</mi>
        <mi>n</mi>
      </msup>
    </math></li>
  <li>Dessous et dessus (<code>munderover)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <munderover>
        <mo movablelimits="false">&#x2211;</mo>
        <mrow>
          <mi>i</mi>
          <mo>=</mo>
          <mn>1</mn>
        </mrow>
        <mi>n</mi>
      </munderover>
    </math></li>
  <li>Dessous (<code>munder)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <munder>
        <mi>x</mi>
        <mo>&#x332;</mo>
      </munder>
    </math></li>
  <li>Dessus (<code>mover)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <mrow>
        <mi>x</mi>
        <mover>
          <mo>&#x2192;</mo>
          <mtext>maps to</mtext>
        </mover>
        <mi>y</mi>
      </mrow>
    </math></li>
  <li>Multi-scripts (<code>mmultiscripts)</code>: <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <mmultiscripts>
        <mi>X</mi>
        <mi>i</mi>
        <mi>j</mi>
        <mprescripts/>
        <mi>k</mi>
        <mi>l</mi>
      </mmultiscripts>
    </math></li>
</ul>

<p>Enfin, le menu <strong>XML/Matrices</strong> vous permet de crer et
diter des tableaux MathML : <math xmlns="http://www.w3.org/1998/Math/MathML">
  <mtable>
    <mtr>
      <mtd>
        <mi>a</mi>
      </mtd>
      <mtd>
        <mi>b</mi>
      </mtd>
    </mtr>
    <mtr>
      <mtd>
        <mi>c</mi>
      </mtd>
      <mtd>
        <mi>d</mi>
      </mtd>
    </mtr>
  </mtable>
</math></p>

<p>Vous devez alors choisir le nombre de lignes et de colonnes dsires et
tableau vide est cre  la position courante. Il se manipule comme <a
href="Tables.html.fr">les tableaux HTML</a> grce aux commandes disponibles
dans le menu <strong>XML/Matrices</strong>.</p>

<h4 id="Palette">La palette MathML</h4>

<p>Cliquer sur un boutton de la palette Math insert la construction
mathmatique reprsente sur son icne. Les parties en noires sont vraiement
insre, les parties en rouge reprsentent des cases  complter, les parties
en bleues sont demandes par le biais d'une fentre de dialogue. Les parties
en vertes sont simplement des informations supplmentaires qui ne sont pas
insres.</p>

<p>La palette contient toutes les constructions dcrites dans le MathML de
contenu (mais le code produit est un quivalent en MathML de prsentation,
voir la section sur les <a href="#Limites">limites courantes</a>) et mme
plus. Vous pouvez aussi enregistrer vos propres constructions dans un fichier
mml pour les utiliser ultrieument. Les 6 onglets sont :</p>
<ol>
  <li><ul>
      <li>Constructions diverses 
        <ul>
          <li>nouvelle formule</li>
          <li><code>mrow</code>: utilis pour regrouper des lments. Voir la
            section sur la <a href="#Row">construction row</a></li>
          <li><code>mphantom</code>: cache un fragment de la formule,
            utilisable pour l'alignement. Les parties caches sont visibles
            si vous slectionnez la formule : 
            <p><math xmlns="http://www.w3.org/1998/Math/MathML">
              <mrow>
                <mo>{</mo>
                <mrow>
                  <mtable>
                    <mtr>
                      <mtd>
                        <mphantom>
                          +</mphantom>
                        <mn>5</mn>
                        <mi>x</mi>
                        <mo>+</mo>
                        <mn>3</mn>
                        <mi>y</mi>
                        <mphantom>
                          <mo>+</mo>
                          <mn>0</mn>
                          <mi>z</mi>
                        </mphantom>
                        <mo>=</mo>
                        <mphantom>
                          +0</mphantom>
                        <mn>0</mn>
                      </mtd>
                    </mtr>
                    <mtr>
                      <mtd>
                        <mo>&#x2212;</mo>
                        <mn>2</mn>
                        <mi>x</mi>
                        <mo>+</mo>
                        <mphantom>
                          <mn>0</mn>
                          <mi>y</mi>
                          <mo>+</mo>
                        </mphantom>
                        <mn>7</mn>
                        <mi>z</mi>
                        <mo>=</mo>
                        <mphantom>
                          +</mphantom>
                        <mn>11</mn>
                      </mtd>
                    </mtr>
                    <mtr>
                      <mtd>
                        <mo>&#x2212;</mo>
                        <mn>3</mn>
                        <mi>x</mi>
                        <mo>+</mo>
                        <mn>2</mn>
                        <mi>y</mi>
                        <mo>&#x2212;</mo>
                        <mn>6</mn>
                        <mi>z</mi>
                        <mo>=</mo>
                        <mo>&#x2212;</mo>
                        <mn>7</mn>
                      </mtd>
                    </mtr>
                  </mtable>
                </mrow>
              </mrow>
            </math></p>
          </li>
          <li>parenthses: <math xmlns="http://www.w3.org/1998/Math/MathML">
              <mrow>
                <mo>(</mo>
                <mi>x</mi>
                <mo>)</mo>
              </mrow>
            </math></li>
          <li>intervalle: On demande les symboles ouvrants/fermants et
            sparateurs. <math xmlns="http://www.w3.org/1998/Math/MathML">
              <mrow>
                <mo>[</mo>
                <mi>a</mi>
                <mo>;</mo>
                <mi>b</mi>
                <mo>]</mo>
              </mrow>
            </math></li>
          <li>fence: Idem, mais le nombre d'lments est demand. <math
            xmlns="http://www.w3.org/1998/Math/MathML">
              <mrow>
                <mo>[</mo>
                <mn>1</mn>
                <mo>,</mo>
                <mi>c</mi>
                <mo>,</mo>
                <mi>Y</mi>
                <mo>,</mo>
                <mi>&#x2147;</mi>
                <mo>,</mo>
                <mo>&#x220f;</mo>
                <mo>}</mo>
              </mrow>
            </math></li>
          <li><code>mtable</code>: <math
            xmlns="http://www.w3.org/1998/Math/MathML">
              <mtable>
                <mtr>
                  <mtd>
                    <mi>a</mi>
                  </mtd>
                  <mtd>
                    <mi>b</mi>
                  </mtd>
                </mtr>
                <mtr>
                  <mtd>
                    <mi>c</mi>
                  </mtd>
                  <mtd>
                    <mi>d</mi>
                  </mtd>
                </mtr>
              </mtable>
            </math></li>
          <li><code>menclose</code>: <math
            xmlns="http://www.w3.org/1998/Math/MathML">
              <menclose>
                <mi>a</mi>
              </menclose>
            </math> or <math xmlns="http://www.w3.org/1998/Math/MathML">
              <menclose  notation="actuarial">
                <mi>b</mi>
              </menclose>
            </math></li>
          <li>selector: On demande le nombre de coordonnes. <math
            xmlns="http://www.w3.org/1998/Math/MathML">
              <msub>
                <mi>a</mi>
                <mrow>
                  <mi>i</mi>
                  <mo>&#x2063;</mo>
                  <mi>j</mi>
                </mrow>
              </msub>
            </math></li>
          <li>accolades avec disjonction de cas ou accolades :<math
            xmlns="http://www.w3.org/1998/Math/MathML">
              <mrow>
                <mo>&#x2223;</mo>
                <mi>x</mi>
                <mo>&#x2223;</mo>
              </mrow>
              <mo>=</mo>
              <mrow>
                <mo>{</mo>
                <mrow>
                  <mtable>
                    <mtr>
                      <mtd>
                        <mi>x</mi>
                        <mtext>if </mtext>
                        <mrow>
                          <mi>x</mi>
                          <mo>&#x2265;</mo>
                          <mn>0</mn>
                        </mrow>
                      </mtd>
                    </mtr>
                    <mtr>
                      <mtd>
                        <mrow>
                          <mo>&#x2212;</mo>
                          <mi>x</mi>
                          <mtext>otherwise</mtext>
                        </mrow>
                      </mtd>
                    </mtr>
                  </mtable>
                </mrow>
              </mrow>
            </math> </li>
        </ul>
      </li>
      <li>Constructions de MathML de prsentation : msup, msub, msubsup,
        mover, munder, munderover, multiscripts.</li>
      <li>Ensembles de nombres: naturels, entiers, rationnels, rels,
        complexes, quaternions, premiers.</li>
      <li>Accents et script en dessous.</li>
    </ul>
  </li>
  <li><ul>
      <li>relations d'quivalence et relations d'ordre 
        <ul>
          <li>galit, approx, congru, isomorphe</li>
          <li>ingalits</li>
          <li>inf, sup, max and min</li>
        </ul>
      </li>
      <li>logique 
        <ul>
          <li>Vrai et Faux</li>
          <li>Equivalence</li>
          <li>Quantificateurs universels et existentiels</li>
          <li>Non, Et, Ou, Ou exclusif, Implique, Equivalent </li>
        </ul>
      </li>
    </ul>
  </li>
  <li><ul>
      <li>thorie des ensembles 
        <ul>
          <li>ensemble/liste construit par extension/sparation, nuplet</li>
          <li>lement, sous ensemble</li>
          <li>ensemble vide, ensemble des parties</li>
          <li>complment, diffrence, diffrence symtrique</li>
          <li>intersection, union, produit cartsien</li>
          <li>cardinal, omega, aleph, intersection diagonale</li>
        </ul>
      </li>
      <li>fonctions et applications 
        <ul>
          <li>construction lambda</li>
          <li>dfinition d'application, flches<math
            xmlns="http://www.w3.org/1998/Math/MathML">
            </math></li>
          <li>domaine, image, codomaine</li>
          <li>identit, composition, application rciproque</li>
        </ul>
      </li>
    </ul>
  </li>
  <li><ul>
      <li>arithmtique 
        <ul>
          <li>somme, produit</li>
          <li>factoriel, combinaison, cardinal</li>
          <li>divise</li>
          <li>ppcm, pgcd</li>
          <li>reste, quotient</li>
        </ul>
      </li>
      <li>oprations 
        <ul>
          <li>oprations lmentaires: plus, moins, fois, division,
          fraction</li>
          <li>puissance, racine</li>
          <li>plancher, plafond</li>
        </ul>
      </li>
      <li>complexes 
        <ul>
          <li>abs (module), arg, conjugu</li>
          <li>cartesien, polaire</li>
          <li>partie relle et imaginaire</li>
        </ul>
      </li>
      <li>constantes: <math xmlns="http://www.w3.org/1998/Math/MathML">
          <mi>&#x2147;</mi>
        </math>, <math xmlns="http://www.w3.org/1998/Math/MathML">
          <mi>&#x2148;</mi>
        </math>, <math xmlns="http://www.w3.org/1998/Math/MathML">
          <mi>&#x3c0;</mi>
        </math>, <math xmlns="http://www.w3.org/1998/Math/MathML">
          <mi>&#x3b3;</mi>
        </math>, <math xmlns="http://www.w3.org/1998/Math/MathML">
          <mi>NaN</mi>
        </math> (non un nombre)</li>
    </ul>
  </li>
  <li><ul>
      <li>analyse 
        <ul>
          <li>differentielle, differentielle partielle</li>
          <li>intgrales: simple/double/triple, normal/contour,
          msub/msupsub</li>
          <li>quivalence</li>
          <li>limite, tend vers</li>
          <li>supminus (<math xmlns="http://www.w3.org/1998/Math/MathML">
              <msup>
                <mn>1</mn>
                <mi>-</mi>
              </msup>
            </math>) ou supplus (<math
            xmlns="http://www.w3.org/1998/Math/MathML">
              <msup>
                <mn>0</mn>
                <mi>+</mi>
              </msup>
            </math>)</li>
          <li>l'infini</li>
          <li>petit et grand O</li>
        </ul>
      </li>
      <li>algbre linaire 
        <ul>
          <li>somme direct</li>
          <li>vecteur ligne/colonne, matrice</li>
          <li>transpose, dterminant</li>
          <li>rot, div, grad, laplacien</li>
          <li>produit vectoriel, produit scalaire, produit externe</li>
          <li>orthogonal, parallle, complmentaire orthogonal, norme</li>
        </ul>
      </li>
      <li>statistique : moyenne, sdev, variance, mdiane, mode, moment</li>
    </ul>
  </li>
  <li>fonctions lmentaires classiques (trigonometriques,
  rciproques...)</li>
</ol>

<h4 id="Clavier">Entrer des constructions  partir du clavier</h4>

<p>Vous n'tes pas oblig d'utiliser un menu ou la palette
<strong>Math</strong> pour crer et diter des expressions mathmatiques.
Vous pouvez entrer des constructions mathmatiques directement  partir du
clavier puisque que chaque entre du menu a un quivalent sur le clavier (les
raccourcis sont indiqus dans les menus). Voir les <a
href="ShortCuts.html.fr">raccourcis</a> clavier courant pour les versions
Linux, Mac OS X, et Windows. Vous pouvez rentrer des lettres grecques via les
raccourcis suivants: (Ctrl) g (Ctrl) [lettre] et (Ctrl + Shift) G (Ctrl +
Shift) [lettre]. </p>

<p>Vous pouvez aussi utiliser les touches directionelles (flches) pour faire
passer le point d'insertion d'une construction  une autre. En particulier,
les deux flches horizontales permettent de se dplacer selon la structure de
l'expression mathmatique. Par exemple, en fin de numrateur d'une fraction,
la flche droite fait passer au dbut du dnominateur. En outre, si vous
utilisez la flche vers la droite  l'intrieur d'une construction non encore
complte, le point d'insertion est directement dplac  la case vide la
plus proche.</p>

<h3>Options d'ditions avances</h3>

<h4 id="Caracteres">Entrer des caractres</h4>

<p>Quand vous tapez une chane de caractres dans un lment MathML, Amaya
analyse cette chane et engendre automatiquement des lments <code>mo</code>
(oprateur), <code>mn</code> (nombre), <code>mi</code> (identificateur), et
<code>mtext</code></p>

<p>Par exemple, pour entrer la formule<math
xmlns="http://www.w3.org/1998/Math/MathML">
  <mrow>
    <mi>x</mi>
    <mo>=</mo>
    <mn>2</mn>
    <mi>a</mi>
    <mo>+</mo>
    <mi>b</mi>
  </mrow>
</math></p>
<ol>
  <li>si vous n'tes pas dans une expression mathmatique, cliquer d'abord
    sur l'entre Nouvelle formule du menu <strong>XML</strong> ou sur le
    bouton <strong>Math</strong> de la palette.</li>
  <li>taper cette squence de 6 caractres : <code>x=2a+b</code></li>
</ol>

<p>Vous pouvez vrifier dans le <a href="#Vue">vue Structure</a> ou source la
structure gnre par Amaya :</p>

<p><code>&lt;mi&gt;x&lt;/mi&gt;&lt;mo&gt;=&lt;/mo&gt;&lt;mn&gt;2&lt;/mn&gt;&lt;mi&gt;a&lt;/mi&gt;&lt;mo&gt;+&lt;/mo&gt;&lt;mi&gt;b&lt;/mi&gt;</code>
</p>

<p>Si le rsultat ne correspond pas exactement  ce que vous vouliez, il
suffit de slectionner les caractres mal interprts et de changer leur type
avec l'une des commandes Texte (mtext), Identificateur (mi), Nombre(mn),
Oprateur (mo) du menu <strong>XML/Math</strong>.</p>

<h4 id="Row">La construction row </h4>

<p>La construction row de la palette est quivalente aux accolades en LaTeX :
elle vous permet de donner des informations sur la faon dont les diffrentes
parties d'une formule sont lies entre elles. Elle n'apparait pas  l'cran
mais peut avoir un effet indirect sur le rendu.</p>

<p>Par exemple, si vous crez des parenthses, comme dans l'expression
suivante :</p>

<p><math xmlns="http://www.w3.org/1998/Math/MathML">
  <mi>f</mi>
  <mrow>
    <mo>(</mo>
    <mi>x</mi>
    <mo>)</mo>
  </mrow>
  <mo>=</mo>
  <mfrac>
    <mn>1</mn>
    <mi>x</mi>
  </mfrac>
</math></p>

<p>taper la squence de caractres <code>f(x)=</code> . . . donnerait :</p>

<p><math xmlns="http://www.w3.org/1998/Math/MathML">
  <mi>f</mi>
  <mo>(</mo>
  <mi>x</mi>
  <mo>)</mo>
  <mo>=</mo>
  <mfrac>
    <mn>1</mn>
    <mi>x</mi>
  </mfrac>
</math></p>

<p>Ici, le (x) doit tre contenu dans un element <code>mrow</code>. Vous
pouvez corriger le problme en slectionnant la partie de la formule puis en
cliquant sur la construction row. Vous pouvez aussi directement obtenir le
<code>mrow</code> souhait en utilisant la commande Parenthses du menu
XML/Math ou de la palette.</p>

<h4 id="Espacement">Espacement</h4>

<p>Amaya gre les espacements  l'intrieur des expressions mathmatiques,
mais vous avez parfois besoin d'ajouter d'autres espaces. Dplacez le curseur
 l'endroit o vous voulez insrer un espace et choisissez <strong>Elments
math de base/Espace (mspace)</strong> dans le menu <strong>XML</strong>. Ceci
crer un espace horizontal par dfaut. Vous pouvez alors changer son attribut
<strong>width</strong> pour ajuster sa taille ou ajouter d'autres attributs
(height, depth, linebreak) pour changer l'espacement vertical. Voir la <a
href="http://www.w3.org/TR/MathML2/chapter3.html#N9197">spcification
MathML</a> pour plus de dtails.</p>

<h4 id="Speciaux">Caractres spciaux</h4>

<p>Pour entrer les caractres et symboles mathmatiques qui ne sont pas
disponibles au clavier, vous pouvez utiliser la commande <a
href="#Caracteres">Caractres</a> du menu <strong>XML/Elments math de
base</strong>. Tapez le nom du caractre (la liste des noms est disponible
dans la <a
href="http://www.w3.org/TR/2003/REC-MathML2-20031021/byalpha.html">spcification
MathML</a>). Au lieu du nom, vous pouvez entrer la valeur Unicode du
caractre. Pour entrer cette valeur en dcimal, commencez par '#'. Pour
l'entrer en hexadcimal, commencez par '#x'. Pour acclrer la frappe, vous
pouvez entrer directement une valeur hexadcimal, sans la faire prcder de
'#x', mais cela peut donner une ambigut (comme 'af', par exemple). En cas
d'ambigut, la alpes saisie est interprte comme un nom de caractre.</p>

<p>Vous pouvez aussi utiliser la palette <strong>Caractres spciaux</strong>
qui se trouve en-dessous de la palette Math. Les boutons de la partie
suprieure de cette palette permettent de choisir un groupe de caractres qui
sont alors disponibles dans le menu qui se trouve en-dessous. Choisissez le
caractre voulu dans ce menu, puis insrez-le dans le document  l'aide du
bouton voisin.</p>

<p>En outre, la spcification MathML dit d'ajouter des caractres invisibles
pour que la lecture de la formule soit plus facile pour les synthtiseurs
vocaux. Ils sont automatiquement insrs dans les contructions de la palette
mais parfois vous devez le faire vous mme. Vous pouvez utiliser le
<strong>menu XML</strong> ou des <a href="ShortCuts.html.fr">raccourcis</a>.
Les trois caractres invisibles sont :</p>
<ol>
  <li>le produit invisible : <math xmlns="http://www.w3.org/1998/Math/MathML">
      <mi>a</mi>
      <mo>&#x2062;</mo>
      <mi>b</mi>
    </math></li>
  <li>l'application de fonction : <math
    xmlns="http://www.w3.org/1998/Math/MathML">
      <mi>f</mi>
      <mo>&#x2061;</mo>
      <mrow>
        <mo>(</mo>
        <mi>x</mi>
        <mo>)</mo>
      </mrow>
    </math></li>
  <li>la virgule invisible : <math xmlns="http://www.w3.org/1998/Math/MathML">
      <msub>
        <mi>a</mi>
        <mrow>
          <mi>i</mi>
          <mo>&#x2063;</mo>
          <mi>j</mi>
        </mrow>
      </msub>
    </math></li>
</ol>

<h4 id="Structure">Editer la structure</h4>

<p>Si vous voulez changer la structure d'une expression existante, pour
ajouter par exemple un exposant ou mettre des parenthses autour d'une
expression, il suffit de slectionner dans le document l'expression 
transformer et d'entrer la nouvelle expression avec la palette Math, le menu
<strong>XML/Constructions math</strong> ou le <a href="#Clavier">clavier</a>.
Vous pouvez galement utiliser la commande <strong>Transformer</strong> du
menu <strong>Edition</strong>. Slectionnez l'expression que vous voulez
transformer et la commande <strong>Transformer</strong> affichera un menu
avec tous les changements possibles.</p>

<h4 id="Vue">Vue Structure</h4>

<p>Toutes les fois qu'un document contient des lments MathML, la slection
de l'article <a href="Views.html.fr#Structure">Montrer la structure</a> du
menu <strong>Vues</strong> ouvre la vue Structure qui montre la structure
principale du document HTML. Dans cette vue, les lments MathML et leur
contenu effectif sont affichs.</p>

<p>Vous pouvez diter des expressions mathmatiques aussi bien dans la vue
principale que dans la vue Structure. La vue Structure est particulirement
utile pour viter l'ambigut. Observez l'exemple suivant :</p>
<math xmlns="http://www.w3.org/1998/Math/MathML">
  <mrow>
    <mi>x</mi>
    <mo>=</mo>
    <msqrt>
      <mrow>
        <mi>a</mi>
        <mo>+</mo>
        <mi fontstyle="italic">b</mi>
      </mrow>
    </msqrt>
    <mo>+</mo>
    <mn>1</mn>
  </mrow>
</math> 

<p>Lorsque vous dplacez le point d'insertion aprs le caractre <em>b</em>,
il n'est pas vident de distinguer si vous voulez ajouter quelque chose <em>
l'intrieur</em> de la racine carre ou <em>aprs</em> elle. Slectionner (ou
vrifier ) dans la vue Structure vite toute ambigut. Vous pouvez galement
vrifier dans la ligne d'tat, en bas de la fentre.</p>

<h4 id="liens">Les liens dans MathML</h4>

<p>Vous pouvez crer et utiliser des liens hypertexte dans des expressions
mathmatiques. Ces liens sont reprsents en utilisant le <a
href="http://www.w3.org/TR/WD-xlink">XML Linking Language (XLink)</a>. Seuls
les liens simples unidirectionnels sont utilisables, mais vous pouvez
associer un lien  n'importe quelle partie d'une formule. Par exemple, la
fraction dans la formule ci-dessous est un lien vers la page d'accueil du
W3C:</p>
<math xmlns="http://www.w3.org/1998/Math/MathML">
  <mrow>
    <mi>y</mi>
    <mo>=</mo>
    <mfrac xmlns:xlink="http://www.w3.org/1999/xlink"
    xlink:href="http://www.w3.org/">
      <mn>1</mn>
      <msqrt>
        <mrow>
          <msup>
            <mi>x</mi>
            <mn>2</mn>
          </msup>
          <mo>+</mo>
          <mn>1</mn>
        </mrow>
      </msqrt>
    </mfrac>
  </mrow>
</math> 

<p>Cliquer deux fois sur un des caractres  l'intrieur de la fraction fait
apparatre la page d'accueil du W3C.</p>

<p>Pour crer un tel lien, il suffit de slectionner une expression (la
fraction dans l'exemple ci-dessus), de cliquer sur le bouton Lien de la
palette XHTML (ou de slectionner l'entre "Crer/changer lien" du menu
Liens), et de cliquer sur la cible dsire. Si la cible est une expression
dans une formule, vous devez d'abord faire de cette expression une cible. Il
suffit de slectionner l'expression ainsi que l'entre "Crer cible" du menu
Liens. Ceci cre un attribut <code>id</code> pour l'expression cible.</p>

<h3>Un peu plus  propos de MathML</h3>

<h4 id="Compatib">Compatibilit des navigateurs</h4>

<p>Firefox ou autres navigateurs bass sur Gecko supportent le MathML, tandis
que Internet Explorer a besoin d'un plugin.</p>

<p>Il faut utiliser le suffixe <code>.xml</code> pour tre sr que tous les
browsers traitent les documents XHTML comme du XML et donc affichent
correctement les documents incluant des formules mathmatiques.</p>

<p>Il est aussi recommand d'utiliser le charset <strong>utf-8</strong> pour
les documents XML.</p>

<p>Par dfaut Amaya ajoute le doctype <code>XHTML 1.1 plus MathML 2.0</code>
en tte du document. Ce doctype n'est pas obligatoire mais il est utile :</p>
<ul>
  <li>pour valider le document,</li>
  <li>pour engendrer des entits alphanumriques (<strong>&amp;int;</strong>
    par exemple) pour les symboles mathmatiques, dans le code source. Sinon
    les symboles mathmatiques seront cods comme tout autre caractre
    unicode.</li>
</ul>

<p>Malheureusement, ce doctype n'est pas support par beaucoup de browsers.
Il peut donc tre ncessaire de le supprimer avec la commande
<strong>Fichier&gt;Changer le type du document&gt;Supprimer le
doctype</strong>.</p>

<p>IE utilise la feuille de transformation <code>pmathml.xsl</code> et un
plugin pour afficher le code MathML inclus. Amaya ajoute automatiquement le
lien vers la feuille de transformation, mais il faut penser  dposer une
copie de cette feuille de transformation (<a
href="http://www.w3.org/Math/XSL/pmathml.xsl">pmathml.xsl</a>) dans le
rpertoire local du document.</p>

<h4 id="Limites">Limites courantes</h4>
<ul>
  <li>Amaya implmente seulement les <em>Balises de Prsentation</em> de
    MathML 2.0, et non le <em>Balisage du Contenu</em>.</li>
  <li>Certaines balises de prsentation ne sont pas entirement disponibles:
    <code>mglyph</code>, <code>maction</code></li>
  <li>Tous les lments de prsentation et les attributs sont utilisables,
    mais seuls les attributs suivant sont pris en compte dans le formatage:
    <code>display, alttext</code>, <code>mathvariant, mathsize</code>,
    <code>mathcolor, mathbackground, fontsize, fontweight</code>,
    <code>fontstyle</code>, <code>fontfamily</code>, <code>color</code>,
    <code>linethickness</code>, <code>numalign</code>,
    <code>denomalign</code>, <code>bevelled</code>, <code>notation</code>,
    <code>lquote</code>, <code>rquote</code>, <code>lspace</code>,
    <code>rspace</code>, <code>largeop</code>, <code>movablelimits,
    subscriptshift</code>, <code>superscriptshift</code>, <code>form</code>,
    <code>width</code> (<code>mspace</code>), <code>height</code>
    (<code>mspace</code>), <code>depth</code> (<code>mspace</code>),
    <code>align</code>, <code>rowalign</code>, <code>columnalign</code>,
    <code>frame</code>, <code>framespacing</code>,
    <code>displaystyle,side</code>, <code>rowspan</code>, <code>columnspan,
    rowspacing, columnspacing, rowlines, columnlines</code>.</li>
  <li>Les attributs <code>class</code>, <code>id</code> et <code>style</code>
    sont utilisables, avec la mme smantique que dans HTML : vous pouvez <a
    href="StyleSheets.html.fr">associer du style CSS</a> aux lments MathML
    (attribut <code>class</code> et <code>style</code>) et un lment MathML
    peut tre la cible d'un lien (attribut <code>id</code>).</li>
  <li>Amaya utilise les polices STIX pour afficher des symboles
    mathmatiques, mais tous ne sont pas supports. </li>
</ul>
</div>
</body>
</html>
