// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "aliasesaddrfilter.h"
#include <fstream>
#include <cctype>
#include <iostream>
#include <algorithm>

aliasesAddrFilter::aliasesAddrFilter() :
		strPrefix( "aliases" ),
		strName( "Aliases Addressfilter" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Use the aliases File to translate the email adress.." )
{
	addParam( "file", "Set the filename for the aliases file.", "Absolute path.", STRING, "no" );
	addParam( "domain", "The primary Domain of the Mailserver.", "a valid domainname.", G_STRING, "" );
	addParam( "scramble", "scramble all names for public screenshots.", "this is a flag.", FLAG, "" );
}

aliasesAddrFilter::~aliasesAddrFilter()
{
}

bool aliasesAddrFilter::init( void )
{
	// Open an alias file?
	if( getStringParam( "file" ) != "no" )
	{
		// Try, to open the Aliases File:
#ifdef DEBUG
		std::cout << "Try to open the File \"" << getStringParam( "file" ) << "\"..." << std::endl;
#endif
		std::fstream f( getStringParam( "file" ).c_str(), std::ios::in );
		if( !f )
		{
			std::cerr << "Can't open file \"" << getStringParam( "file" ) << "\"." << std::endl;
			return false;
		}

		// Read line per line.
		char buffer[ 1024 ];
		std::string line;
		std::string alias;
		std::string account;
		long lc = 0;
		std::string::size_type i;

		while( f.getline( buffer, 1024, '\n' ) )
		{
			lc++;
			line = buffer;
			if( line[ 0 ] == '#' ) continue;
			if( line.find( "," ) != std::string::npos ) continue;
			if( ( i = line.find( ":" ) ) != std::string::npos )
			{
				alias = line.substr( 0, i );
				account = line.substr( i + 1 );
				if( account.find( ":include:" ) != std::string::npos ) continue;
				if( account.find( "\"" ) != std::string::npos ) continue;
				while( ( i = alias.find_first_not_of( "abcdefghijklmnopqrestuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-." ) ) != std::string::npos )
					alias.erase( i, 1 );
				while( ( i = account.find_first_not_of( "abcdefghijklmnopqrestuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-." ) ) != std::string::npos )
					account.erase( i, 1 );
#ifdef DEBUG
				std::cout << "Add alias \"" << alias << "\" -> \"" << account << "\"." << std::endl;
#endif
				alias_map[ alias ] = account; // add this alias to the map.
			}
		}
	}
	scramble = 0;

	// Splitup the domainlist
	std::string dl = getStringParam( "domain" );
	std::string::size_type pos;
	while( (pos = dl.find( "," )) != std::string::npos )
	{
		if( pos > 0 ) domain_list.push_back( dl.substr( 0, pos ) );
		dl.erase( 0, pos + 1 );
	}

	return true; // ok...
}

bool aliasesAddrFilter::checkAddr( std::string &addr )
{
	int tc; // try counter.
	bool changed = false;
	std::string::size_type i;
	std::string domain, name;

	if( ( addr[ 0 ] == '<' ) && ( addr.size() > 1 ) )  // erase <> around the email address...
	{
		changed = true;
		addr.erase( 0, 1 );
		addr.erase( addr.size() - 1, 1 );
	}
	if( ( i = addr.find( "@" ) ) != std::string::npos )  // inet addr?
	{
		domain = addr.substr( i + 1 );
		// is the domain in the domainlist, then this is a local mailaddress
		if( std::find( domain_list.begin(), domain_list.end(), domain ) != domain_list.end() )
		{
			addr = addr.substr( 0, i );
			changed = true;
			for( tc = 0; tc < 10; tc++ )  // max. 10 changes.
			{
				if( alias_map.find( addr ) == alias_map.end() ) break;
				addr = alias_map[ addr ];
			}
		}
	}
	else
	{ // no only local
		for ( tc = 0; tc < 10; tc++ )  // max. 10 changes.
		{
			if ( alias_map.find( addr ) == alias_map.end() ) break;
			addr = alias_map[ addr ];
			changed = true;
		}
	}
	if( getFlagParam( "scramble" ) )  // scrambling output
	{
		std::string::size_type x;
		for ( x = 0; x < addr.size(); x++ )
		{
			if ( ++scramble > 10 ) scramble = 0;
			if ( addr[ x ] >= 'a' && addr[ x ] <= 'z' )
			{
				addr[ x ] = addr[ x ] + scramble;
				if ( !isalpha( ( int ) addr[ x ] ) ) addr[ x ] = 'x';
			}
		}
		changed = true;
	};
	return changed;
};
