/* Copyright (C) 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <qfile.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "checkOverWrite.hpp"

QString checkOverWrite( const QString &fileName, QWidget *parent )
{
  QString retVal;
  if( QFile::exists( fileName ))
    if ( KMessageBox::warningContinueCancel
         ( parent,
           i18n( "The file %1 already exists and it will be overwritten!" ).
           arg( fileName ) ) !=
         KMessageBox::Continue )
      retVal = QString::null;
    else
      retVal = fileName;
  else
    retVal = fileName;
  return retVal;
}
