 /* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __MYSQLDAEMON_HPP
#define __MYSQLDAEMON_HPP

#include <boost/smart_ptr.hpp>
#include <sstream>
#include <string>
#include "error.hpp"
#include "object.hpp"

/** @addtogroup mysqlCpp
    @{ */
class MySQLDaemon: public Object
{
public:
  /** Constructor.
      @param _datadir Directory of database server.
      @param _socket The database-server should use this file-socket. */
  MySQLDaemon( const std::string &_datadir, const std::string &_socket )
    throw (Error);
  ///
  virtual ~MySQLDaemon(void);
  ///
  bool running(void);
  ///
  const std::string getLog(void);
  /** Create database.
      This method calls 'mysql_install_db' to create the database directories.
      @param _datadir Directory for database.
      @param _socket Temporary socket required by some distributions.
      @return Output generated by mysql_install_db. */
  static std::string create( const std::string &_datadir,
                             const std::string &_socket ) throw (Error);
protected:
  ///
  void readPending(void);
  ///
  int pipes[2];
  ///
  pid_t pid;
  ///
  std::ostringstream log;
};

///
typedef boost::shared_ptr< MySQLDaemon > MySQLDaemonPtr;

///@}

#endif
