/***************************************************************************
                          apollonsystemtray.cpp  -  description
                             -------------------
    copyright            : (C) 2003 Martin Koebele
    email                : martin@mkoebele.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>

#include <kapplication.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <qstring.h>
#include <qtooltip.h>
#include <qpoint.h>

#include "apollonsystemtray.h"

ApollonSystemTray::ApollonSystemTray(QWidget *parent, const char *name) : KSystemTray(parent, name)
{
   
    
    appPix   = SmallIcon("apollon");
    counter = 0;
    actives = 0;
    rate = 0;
    setPixmap(appPix);
    //    KPopupMenu *cm = contextMenu();
   
}

ApollonSystemTray::~ApollonSystemTray()
{

}

void ApollonSystemTray::statsUpdate(int a, float r){
  QString s;
  actives = a;
  rate = r;
  s = i18n("%1 active downloads at %2 KB/s").arg(actives).arg(rate);
  QToolTip::add(this, s);
}

#include "apollonsystemtray.moc"

