use Digest::SHA1;

# remove suffix
my $filename = $ARGV[0];
$filename =~ s/\.diff_Index//;

# Read diff.Index
open(DIFFIN, $ARGV[0]) || die("Cannot open $ARGV[0]");
$curr= <DIFFIN>; # need to check this matches /SHA1/
chomp $curr;
while (<DIFFIN>) {
    next if $. == 2;
    last if (/^SHA1/);
    push @hist, $_;
    next;
 }
while (<DIFFIN>) {
    push @patch, $_;
    next;
 }
close (DIFFIN);

open(PACK, $filename) || die("Cannot open $filename");
my $sha1 = Digest::SHA1->new;
$sha1->addfile(PACK);
close(PACK);
my $digest = $sha1->hexdigest;

my @info = stat $filename;

for (@hist) {
    split;
    if ($info[7] == $@[1] && $digest == $@[0]) {
	print "found at \$hist $.\n";
	last
    }
}

print "$curr: $digest, $info[7]\n";

if ($info[7] != (split (/\s+/,$curr))[2]) {
    print "size mismatch\n";
}
if ($digest != (split (/\s+/,$curr))[1]) {
    print "SHA1 mismatch\n";
}




