/*                                                     -*- linux-c -*-
    Copyright (C) 2004 Tom Szilagyi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: playlist.h 695 2007-06-25 13:35:43Z peterszilagyi $
*/


#ifndef _PLAYLIST_H
#define _PLAYLIST_H

#include <config.h>

#include "common.h"

#define PLAYLIST_LOAD     0
#define PLAYLIST_LOAD_TAB 1
#define PLAYLIST_ENQUEUE  2

typedef struct {

	AQUALUNG_THREAD_DECLARE(thread_id)
	AQUALUNG_MUTEX_DECLARE(thread_mutex)
	AQUALUNG_MUTEX_DECLARE(wait_mutex)
	AQUALUNG_COND_DECLARE(thread_wait)

	volatile int thread_stop;

	int progbar_semaphore;
	int ms_semaphore;

	int index;

	char name[MAXLEN];
	int name_set;
	int playing;
	int closed;

	GtkTreeStore * store;
	GtkTreeSelection * select;
	GtkWidget * view;
	GtkWidget * scroll;
	GtkWidget * label;
	GtkWidget * tab_close_button;
	GtkWidget * tab_menu;
	GtkWidget * tab__close_undo;

	GtkTreeViewColumn * track_column;
	GtkTreeViewColumn * rva_column;
	GtkTreeViewColumn * length_column;

	GtkWidget * progbar;
	GtkWidget * progbar_container;
	GtkWidget * progbar_stop_button;

	GtkWidget * widget;

} playlist_t;

typedef struct {

	playlist_t * pl;

	volatile int data_written;

	GSList * list;
	GList * plfm_list;

	void * xml_doc;
	void * xml_node;
	int * xml_ref;

	char * filename;

	int clear;
	int start_playback;

} playlist_transfer_t;

playlist_t * playlist_tab_new(char * name);
playlist_t * playlist_tab_new_if_nonempty(char * name);

playlist_t * playlist_get_current(void);
void playlist_set_current(playlist_t * pl);
playlist_t * playlist_get_playing(void);

GtkTreePath * playlist_get_playing_path(playlist_t * pl);

void delayed_playlist_rearrange(playlist_t * pl);
void playlist_size_allocate_all(void);
void playlist_reorder_columns_all(int * order);
void playlist_show_hide_close_buttons(gboolean state);

void create_playlist(void);
void show_playlist(void);
void hide_playlist(void);

void playlist_set_playing(playlist_t * pl, int playing);

void playlist_stats_set_busy(void);
void playlist_progress_bar_show(playlist_t * pl);
void playlist_progress_bar_hide_all(void);
void show_hide_close_buttons(gboolean state);

void playlist_ensure_tab_exists(void);
void playlist_load(GList * list, int mode, char * tab_name, int start_playback);
void playlist_save_all(char * filename);

void playlist_set_color(void);
void playlist_disable_bold_font(void);

void playlist_content_changed(playlist_t * pl);
void playlist_selection_changed(playlist_t * pl);
void playlist_drag_end(GtkWidget * widget, GdkDragContext * drag_context, gpointer data);
gint playlist_window_key_pressed(GtkWidget * widget, GdkEventKey * kevent);
void playlist_foreach_selected(playlist_t * pl,
			       int (* foreach)(playlist_t *, GtkTreeIter *, void *),
			       void * data);

void mark_track(GtkTreeStore * store, GtkTreeIter * piter);
void unmark_track(GtkTreeStore * store, GtkTreeIter * piter);

void show_active_position_in_playlist(playlist_t * pl);

#ifdef HAVE_CDDA
void playlist_add_cdda(GtkTreeIter * iter_drive, unsigned long hash);
void playlist_remove_cdda(char * device_path);
#endif /* HAVE_CDDA */

enum {
	PL_COL_TRACK_NAME = 0,
	PL_COL_PHYSICAL_FILENAME,
	PL_COL_SELECTION_COLOR,
	PL_COL_VOLUME_ADJUSTMENT,
	PL_COL_VOLUME_ADJUSTMENT_DISP,
	PL_COL_DURATION,  
	PL_COL_DURATION_DISP,
	PL_COL_FONT_WEIGHT,

	PL_NUM_OF_COLUMNS /* it must be the last entry here */
};

#endif /* _PLAYLIST_H */

// vim: shiftwidth=8:tabstop=8:softtabstop=8 :  
