# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::Widget::Diff;

use base qw(ArchWay::Widget::Text);

sub show ($$) {
	my $self = shift;
	my $diff = shift;

	$self->clear;

	return unless defined $diff;

	my $buffer = $self->get_buffer;
	my $iter = $buffer->get_iter_at_offset(0);
	my $start = $iter;
	foreach my $line (split /\n/, $diff) {
		my $tag = undef;
		if ($line =~ /^\+\+\+/) {
			$tag = 'patch_new';

		} elsif ($line =~ /^---/) {
			$tag = 'patch_old';

		} elsif ($line =~ /^@@/) {
			$tag = 'patch_lines';

		} elsif ($line =~ /^\+/) {
			$tag = 'patch_add';

		} elsif ($line =~ /^-/) {
			$tag = 'patch_del';

		} elsif ($line =~ /^!/) {
			$tag = 'patch_mod';
		}

		if (defined $tag) {
			$buffer->insert_with_tags_by_name($iter, $line, $tag);
		} else {
			$buffer->insert($iter, $line);
		}

		$buffer->insert($iter, "\n");
	}
}

1;

__END__
