# these variables are set (and configurable) using "make rpm-dist" procedure
%define ver 0.0.0
%define rel 1
%define c_p --not-used
%define m_p JUST=/an/example

%define _prefix /usr
%define _sourcedir /tmp

Name:      archway
Version:   %ver
Release:   %rel
Vendor:    Mikhael Goikhman <migo@homemail.com>
License:   GPL
Group:     Development/Tools
Summary:   ArchWay is a GNU Arch GUI
Source:    http://savannah.nongnu.org/download/archway/%name-%version.tar.gz
URL:       http://www.nongnu.org/archway/
Requires:  perl-Arch >= 0.5.1
Requires:  tla >= 1.1, perl >= 5.8.0
Requires:  perl-Gtk2 >= 1.0.40, perl-Glib >= 1.0.40
Requires:  gtk2 >= 2.4.0, glib2 >= 2.4.0
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-%(%{__id_u} -n)

%description 
ArchWay is a GNU Arch GUI.  It follows the unix tradition of small tools
doing their work well and cooperating nicely with each other.

Some tips: in a working tree, run "archelf" to operate on project files;
run "archmag" to manage tree merges; run "archeye ." to view tree changes;
run "archeye ,,undo-1" to view a given changeset; run "archrog" to manage
registered archives; and so on.

Alternativelly, just run "archway" and choose the desired tools from there.

%define perl_vendorlib %(eval `perl -V:vendorlib`; echo $vendorlib)

%prep
%setup -q

%build

%clean
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=%_prefix DESTDIR=$RPM_BUILD_ROOT WITH_ARCH_PERL=no

mkdir -p $RPM_BUILD_ROOT%perl_vendorlib
mv $RPM_BUILD_ROOT%_datadir/%name/perllib/ArchWay $RPM_BUILD_ROOT%perl_vendorlib
rmdir $RPM_BUILD_ROOT/%_datadir/%name/perllib

%files
%doc AUTHORS COPYING NEWS README TODO ChangeLog
%doc doc/CodingStyle doc/REQUIREMENTS doc/THANKS doc/archway-aliases
%_bindir/*
%_datadir/%name
%perl_vendorlib/ArchWay

%define date%(env LC_ALL=C date +"%a %b %d %Y")
%changelog
* %{date} Mikhael Goikhman <migo@homemail.com>
- auto build %{PACKAGE_VERSION}
