/*
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) David Farrell <fdavid@cyberramp.net>
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// 3D Studio object reader

#ifndef ARK_LOADER3DS_H
#define ARK_LOADER3DS_H

namespace Ark
{

   struct H3dsFace
   {
	 int16 p0,p1,p2;
	 int16 flags;
   };
   
// Material structures
   struct H3dsMatList
   {
	 String name;
	 std::vector<uint16> faces;
   };
   
   struct H3dsRGBColor
   {
	 float32 red;
	 float32 green;
	 float32 blue;
   };
   
   struct H3dsTexture
   {
	 String texturename;
	 int16 options;
   };
   
   struct H3dsMat
   {
	 String name;
	 Color ambient;
	 Color diffuse;
	 Color specular;
	 int16 mat_type;
	 int doublesided;
	 H3dsTexture texture;
	 int offset;
	 float32 alpha;
   };
   
// Object and scene structures
   struct H3dsMeshObj
   {
	 String name;                  // object name, zero terminated
	 int matrix;                   // 1 if transformation matrix is loaded
	 std::vector<H3dsFace> facelist;     // array of face indices
	 std::vector<Vector3> vertices;      // array of vertices
	 std::vector<Vector2> texcoords;     // array of texture coordinates
	 float32 TraMatrix[3*4];       // 3*3 rotation matrix,
	                               // 3*1 translation matrix
	 std::vector<H3dsMatList> bindings;  // Binds faces to materials
   };

   struct H3dsScene
   {
       std::vector<H3dsMeshObj> meshobjs;  // array of meshobjects
       std::vector<H3dsMat> materials;      // array of materials
   };

   /// FIXME: architecture check
   typedef long int int32;
   typedef unsigned long int uint32;

   /**
    * Each 3DS data-chunk starts with a 6 byte header.
    * The first item in the header is a 2 byte (word) id-number.
    * After that follows a dword wich gives the size of
    * the data-chunk including the header. The size can be used
    * as an relative offset to the next chunk.
    */
   enum
   {
      H3DS_CHUNK_RGB1       = 0x0010,  // 3 floats of RGB
      H3DS_CHUNK_RGB2       = 0x0011,  // 3 bytes of RGB
      H3DS_CHUNK_RGB3       = 0x0012,  // What is this?
      H3DS_CHUNK_AMOUNT     = 0x0030,
      H3DS_CHUNK_MAIN       = 0x4D4D,
      H3DS_CHUNK_OBJMESH    = 0x3D3D,
      H3DS_CHUNK_BKGCOLOR   = 0x1200,
      H3DS_CHUNK_AMBCOLOR   = 0x2100,
      H3DS_CHUNK_OBJBLOCK   = 0x4000,
      H3DS_CHUNK_TRIMESH    = 0x4100,
      H3DS_CHUNK_VERTLIST   = 0x4110,
      H3DS_CHUNK_FACELIST   = 0x4120,
      H3DS_CHUNK_FACEMAT    = 0x4130,
      H3DS_CHUNK_MAPLIST    = 0x4140,
      H3DS_CHUNK_SMOOLIST   = 0x4150,
      H3DS_CHUNK_TRMATRIX   = 0x4160,
      H3DS_CHUNK_LIGHT      = 0x4600,
      H3DS_CHUNK_SPOTLIGHT  = 0x4610,
      H3DS_CHUNK_CAMERA     = 0x4700,
      H3DS_CHUNK_MATERIAL   = 0xAFFF,
      H3DS_CHUNK_MATNAME    = 0xA000,
      H3DS_CHUNK_AMBIENT    = 0xA010,
      H3DS_CHUNK_DIFFUSE    = 0xA020,
      H3DS_CHUNK_SPECULAR   = 0xA030,
      H3DS_CHUNK_SHININESS       = 0xA040,
      H3DS_CHUNK_SHINE_STRENGTH  = 0xA041,
      H3DS_CHUNK_TRANSPARENCY    = 0xA050,
      H3DS_CHUNK_DOUBLESIDED     = 0xA081,
      H3DS_CHUNK_TEXTURE         = 0xA200,
      H3DS_CHUNK_BUMPMAP   	 = 0xA230,
      H3DS_CHUNK_MAPFILENAME     = 0xA300,
      H3DS_CHUNK_MAPOPTIONS      = 0xA351,
      H3DS_CHUNK_KEYFRAMER 	 = 0xB000,
      H3DS_CHUNK_FRAMES          = 0xB008
   };

}

#endif
