
#include <ArkCollision.h>
#include <ArkSystem.h>

namespace Ark
{
   VersionInfo ColSystem_VERSION = {"ColSystem", 0,1,0};

   ColSystemFactory::ColSystemFactory() : Factory (ColSystem_VERSION)
   {
   }

   ColSystem *
   ColSystemFactory::CreateColSystem(const String &implname,
				     FactoryList *factlist)
   {
      if (factlist == 0)
	 factlist = Ark::Sys()->Factories();
      
      Ark::ColSystemFactory *colsysfac;
      if (!factlist->GetFactory(implname, &colsysfac, ColSystem_VERSION))
	 Ark::Sys()->Fatal("Cannot create a renderer factory !");
      
      return colsysfac->NewColSystem ();
   }

}
