/* $Id: ArkModelBuild.h,v 1.9 2002/10/11 01:10:03 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_MODELBUILD_H
#define ARK_MODELBUILD_H

#include <Ark/ArkModel.h>
#include <set>
#include <vector>


namespace Ark
{
   /// Vertex with all informations needed to build a mesh
   class ARK_DLL_API Vertex
   {
     public:
	 /// Null initializer.
	 Vertex ();

	 /**
	  * Bone this vertex is bound to. Will be used to transform the
	  * vertex.
	  */
	 int m_Bone;
 
	 /// Coordinate of this vertex in 3D space.
	 Vector3 m_Coord;

	 /// Normal
	 Vector3 m_Normal;

	 /// 2D coordinate (UV) for texture mapping
	 Vector2 m_TexCoord;

	 /// Color of the vertex (for Gouraud shading)
	 RGBA m_Color;

      private:
	 friend class ModelBuilder;
	 int m_VBId;
   };

   bool ARK_DLL_API operator < (const Vertex &x, const Vertex &y);
   
   class VBMap;

   class ARK_DLL_API ModelBuilder
   {
	 /** The current model we're building. */
	 SubModel *m_Model;

	 /** This maps vertexes to indices in the vertex buffer */
	 VBMap *m_Map;

	 /** Map current vertex indice to vertex buffer indice */
	 std::vector<int> m_CMap;

	 
	 bool m_ComputeNormal;
	 int FindVertex (const Vertex &vtx);

      public:
	 ModelBuilder (SubModel *m);
	 ~ModelBuilder ();

	 /*
	  * Sets the format of the vertex buffer. This should be called
	  * before any other function is called.
	  */
	 bool SetFormat (int format);

	 bool SetVertices (Vertex *vertices, size_t n);

	 /**
	  * Add a primitive block to the current model ; put it in the
	  * mesh corresponding to material \c mat (create one if it
	  * does not currently exist).
	  */
	 bool AddBlock (int mat, const PrimitiveBlock &block);

	 /// Add a triangle to the current model
	 bool AddTriangle (int material, const Vertex &a,
			   const Vertex &b, const Vertex &c);

	 /// Finish to build the model.
	 bool Build ();
   };
}

#endif
