/* $Id: ArkTexture.cpp,v 1.16 2003/03/20 17:23:25 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sstream>

#include <Ark/ArkTexture.h>
#include <Ark/ArkConfig.h>


namespace Ark
{

Texture::Texture (const String &name, Image *image) : Object (name)
{
  assert (image != NULL);

  m_Image = ImagePtr(image);
  m_Format = image->m_Format;
  m_Width = image->m_Width;
  m_Height = image->m_Height;
  m_Type = V_TEXTURE;
  m_RepeatMode = Image::REPEAT;
}

Texture::Texture (const String &name) : Object (name)
{
  m_Format = Image::I_8;
  m_Width = 1;
  m_Height = 1;
  m_Type = V_TEXTURE;
  m_RepeatMode = Image::REPEAT;
}

Texture::~Texture ()
{
}

bool
Texture::Configure()
{
   return false;
}

String
Texture::Dump (bool long_ver)
{
    std::ostringstream os;
    os << "[tex] " << m_Name;

    return os.str();
}

/* namespace Ark */
}
