
#include <ArkWorldUpd.h>
#include <ArkSystem.h>

namespace Ark
{

   VersionInfo WorldUpdater_VERSION = {"WorldUpdater", 0,1,0};

   WorldUpdaterFactory::WorldUpdaterFactory() : Factory (WorldUpdater_VERSION)
   {
   }

   WorldUpdater *
   WorldUpdaterFactory::CreateWorldUpdater(const String &implname,
					   Cache *cache,
					   bool isServer,
					   FactoryList *factlist)
   {
      if (factlist == 0)
	 factlist = Ark::Sys()->Factories();
      
      Ark::WorldUpdaterFactory *wufac;
      if (!factlist->GetFactory(implname, &wufac, WorldUpdater_VERSION))
	 Ark::Sys()->Fatal("Cannot create a world updater factory !");
      
      return wufac->NewWorldUpdater (cache, isServer);
   }

}
