------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                             A S I S . I D S                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1995-2002, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
--
--
--
--
--
--
--
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------
with Ada.Characters.Handling; use Ada.Characters.Handling;

with A4G.Vcheck; use A4G.Vcheck;

package body Asis.Ids is
------------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Hash (The_Id : in Id) return Asis.ASIS_Integer is
   begin
      pragma Unreferenced (The_Id);
      return 0;
   exception
      when others =>
         Raise_ASIS_Failed (Diagnosis => "Asis.Ids.Hash");
   end Hash;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function "<" (Left  : in Id;
                 Right : in Id) return Boolean is
   begin
      pragma Unreferenced (Left);
      pragma Unreferenced (Right);
      return True;
   exception
      when others =>
         Raise_ASIS_Failed (Diagnosis => "Asis.Ids.""<""");
   end "<";
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function ">" (Left  : in Id;
                 Right : in Id) return Boolean is
   begin
      pragma Unreferenced (Left);
      pragma Unreferenced (Right);
      return False;
   exception
      when others =>
         Raise_ASIS_Failed (Diagnosis => "Asis.Ids."">""");
   end ">";
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Is_Nil (Right : in Id) return Boolean is
   begin
      pragma Unreferenced (Right);
      return True;
   exception
      when others =>
         Raise_ASIS_Failed (Diagnosis => "Asis.Ids.Is_Nil");
   end Is_Nil;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Is_Equal
     (Left  : in Id;
      Right : in Id)
      return Boolean
   is
   begin
      pragma Unreferenced (Left);
      pragma Unreferenced (Right);
      return True;
   exception
      when others =>
         Raise_ASIS_Failed (Diagnosis => "Asis.Ids.Is_Equal");
   end Is_Equal;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Create_Id (Element : in Asis.Element) return Id is
   begin
      pragma Unreferenced (Element);
      return Nil_Id;
   exception
      when others =>
         Raise_ASIS_Failed (Diagnosis => "Asis.Ids.Create_Id");
   end Create_Id;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Create_Element
     (The_Id      : in Id;
      The_Context : in Asis.Context)
      return Asis.Element
   is
   begin
      pragma Unreferenced (The_Id);
      pragma Unreferenced (The_Context);
      return Nil_Element;
   exception
      when others =>
         Raise_ASIS_Failed (Diagnosis => "Asis.Ids.Create_Element");
   end Create_Element;
-----------------------------------------------------------------------------
--  NOT IMPLEMENTED

   function Debug_Image (The_Id : in Id) return Wide_String is
   begin

      if Is_Nil (The_Id) then
         return Nil_Asis_Wide_String;
      else
         return To_Wide_String (The_Id.all);
      end if;

   end Debug_Image;
-----------------------------------------------------------------------------
end Asis.Ids;
