------------------------------------------------------------------------------
--                                                                          --
--                      GNAT METRICS TOOLS COMPONENTS                       --
--                                                                          --
--                      M E T R I C S . O P T I O N S                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                   Copyright (C) 2003-2004, ACT Europe                    --
--                                                                          --
-- GNAT Metrics Toolset  is free software;  you can  redistribute it and/or --
-- modify it under terms of the  GNU General Public License as published by --
-- the Free Software Foundation;  either version 2, or (at your option) any --
-- later version.  GNAT Metrics Toolset is  distributed in the hope that it --
-- will be useful, but  WITHOUT ANY WARRANTY; without even the implied war- --
-- ranty of  MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the --
-- GNU General Public License for more details.  You should have received a --
-- copy of the  GNU General Public License distributed with  GNAT; see file --
-- COPYING.  If not,  write to the  Free  Software  Foundation,   59 Temple --
-- Place - Suite 330, Boston,                                               --
--                                                                          --
-- GNAT Metrics Toolset is maintained by ACT Europe                         --
-- (http://www.act-europe.fr).                                              --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines a set of options for metric tools

package METRICS.Options is

   Verbose_Mode : Boolean := False;
   --  In verbose mode gnatmetric outputs in Standard_Error the version
   --  information, and then it outputs the trace of processed units

   Quiet_Mode : Boolean := False;
   --  In quiet mode gnatmetric does not print anything in Standard Error
   --  except the diagnostic and warning messages

   Debug_Output : Boolean := False;
   --  Generates various messages useful to understand what happens inside
   --  gnatmetric

   Progress_Indicator_Mode : Boolean := False;
   --  Generates the output to be used for GPS progress indicator.

   Short_SFN_In_Output : Boolean := False;
   --  Put short file name in the output information (by default the source
   --  file name in the output information generated by GNATMETRIC contains the
   --  full path).

   Compute_Local_Metrics : Boolean := True;
   --  Indicates if the detailed metrics should be computed for nested
   --  program units.

   ---------------------------
   -- Line metrics settings --
   ---------------------------

   Compute_All_Lines     : Boolean := True;
   Compute_Code_Lines    : Boolean := True;
   Compute_Comment_Lines : Boolean := True;
   Compute_EOL_Comments  : Boolean := True;
   Compute_Blank_Lines   : Boolean := True;

   ------------------------------
   -- Element metrics settings --
   ------------------------------

   Compute_All_Statements      : Boolean := True;
   Compute_All_Declarations    : Boolean := True;
   Compute_Progam_Unit_Nesting : Boolean := True;
   Compute_Construct_Nesting   : Boolean := True;
   Compute_Public_Subprograms  : Boolean := True;
   Compute_All_Subprograms     : Boolean := True;
   Compute_Public_Types        : Boolean := True;
   Compute_All_Types           : Boolean := True;

   ----------------------------------
   --  Complexity metrics settings --
   ----------------------------------

   Compute_Cyclomatic_Complexity : Boolean := True;
   Compute_Essential_Complexity  : Boolean := True;
   Treat_Exit_As_Goto            : Boolean := True;

   --  Nesting levels
   Compute_Loop_Nesting          : Boolean := True;

   function Line_Metrics_Set return Boolean;
   function Selective_Line_Metrics_Set return Boolean;
   --  These functions are used to simplify conditions used to turn off line
   --  metrics computations (which are rather time-consuming). The first
   --  one says if at least one line metric should be computed, the last one
   --  says if we have to compute the number of lines of a specific type,
   --  that is, if we have to get the list of all the lines and to iterate
   --  through this list

   function Complexity_Metrics_Set return Boolean;
   --  Checks if at least one complexity metric is set. At the moment we
   --  consider the following metrics as complexity metrics:
   --    cyclomatic complexity
   --    essential complexity
   --    loop nesting

   procedure Line_Metrics_Off;
   procedure Element_Metrics_Off;
   --  Turns off all the metrics of the corresponding kind

end METRICS.Options;
