------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                   G N A T P P . E N V I R O N M E N T                    --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                   Copyright (C) 2003-2004, ACT Europe                    --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains routines performing initialization and finalization
--  actions

with GNATPP.Source_Table; use GNATPP.Source_Table;

package GNATPP.Environment is

   procedure Init;
   --  This procedure is responsible for the establishment of all associations
   --  between the tool and the underlying operating system. It processes
   --  command line switches and determines the file(s) to be processed.

   procedure Clean_Up;
   --  Performs the final clean-up actions, including deletion of the temporary
   --  directory. Outputs the summary failures information in case of multiple
   --  file processing.

   procedure Source_Clean_Up (SF : SF_Id);
   --  Clean-up procedure called when processing of the tree created for a
   --  given source is completed or interrupted because of the exception raise.
   --  Closes the ASIS Context, closes the out file if needed, removes tree and
   --  ALI files from temporary dir.

end GNATPP.Environment;
