#!/bin/sh
if [ -z ${TARGET} ];then
	echo -en "\n\nThis script has to be invoked by 'make test' from the toplevel directory\n\n"
	exit
fi

if (test $1);then
	if (test -e $1);then
		export TEST_FILES=$1;
	else
		echo "Test file '$1' not found";
		exit;
	fi
else
	export TEST_FILES=`find . -maxdepth 1 -name 'test_??' -printf '%p '`;
fi

export AGCC=../../AspectC++/bin/${TARGET}/ag++
export ERR_SUM="+-----------------+\n";
export ERR_SUM="${ERR_SUM}| Error Messages: |\n";
export ERR_SUM="${ERR_SUM}+-----------------+\n";
export ERR_OCCURED=0;
export STDOUT_FILE=stdout.tmp;
export STDERR_FILE=stderr.tmp;
for testfile in ${TEST_FILES};
do
	rm -f puma.config;
	ERR_MSG="";
	source $testfile;
	exec 6>&1;	
	exec 7>&2;	
	exec > $STDOUT_FILE;
	exec 2> $STDERR_FILE;
	main ;
	RET=$?;
	exec 1>&6 6>&-;
	exec 2>&7 7>&-;
	if [ $RET == 1 ]; then
		echo -n ".";
	else
		export ERR_OCCURED=1;
		export STDOUT=`cat $STDOUT_FILE`;
		export STDERR=`cat $STDERR_FILE`;
		echo -n "[${testfile/test_/}:F]";
		export ERR_SUM="${ERR_SUM}\n\n-----------------------------------------------------------------------------------------\n";
		export ERR_SUM="${ERR_SUM}TESTFILE: ${testfile}\n";
		export ERR_SUM="${ERR_SUM}-----------------------------------------------------------------------------------------\n\n";
		export ERR_SUM="${ERR_SUM}TEST DESCRIPTION: ${DESC//'\\'/\\\\}\n";
		export ERR_SUM="${ERR_SUM}-----------------\n\n";
		export ERR_SUM="${ERR_SUM}ERROR: ${ERR_MSG//'\\'/\\\\}\n";
		export ERR_SUM="${ERR_SUM}------\n\n";
		export ERR_SUM="${ERR_SUM}STDOUT:\n";
		export ERR_SUM="${ERR_SUM}-------\n${STDOUT//'\\'/\\\\}\n";
		export ERR_SUM="${ERR_SUM}STDERR:\n";
		export ERR_SUM="${ERR_SUM}-------\n${STDERR//'\\'/\\\\}\n";
	fi
	rm -f puma.config;
	
done
echo;
echo;
if [ $ERR_OCCURED == 1 ];then
	echo -e "$ERR_SUM";
else
	echo "All tests OK";
fi

rm $STDERR_FILE $STDOUT_FILE;

