// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeQualified_h__
#define __CTypeQualified_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CTypeQualified : public CTypeInfo {
  bool _Const;
  bool _Volatile;
  bool _Restrict;

protected:
  CTypeQualified (CTypeInfo *, bool, bool, bool, TypeId);
  
public:
  CTypeQualified (CTypeInfo *, bool, bool, bool);
  ~CTypeQualified ();

  bool isConst () const;
  bool isVolatile () const;
  bool isRestrict () const;

  void isConst (bool);
  void isVolatile (bool);
  void isRestrict (bool);
};

inline CTypeQualified::CTypeQualified (CTypeInfo *base, bool c, bool v, bool r, 
 CTypeInfo::TypeId id) :
  CTypeInfo (base, id),
  _Const (c),
  _Volatile (v),
  _Restrict (r)
 {}
inline CTypeQualified::CTypeQualified (CTypeInfo *base, bool c, bool v, bool r) :
  CTypeInfo (base, CTypeInfo::TYPE_QUALIFIED),
  _Const (c),
  _Volatile (v),
  _Restrict (r)
 {}
inline CTypeQualified::~CTypeQualified ()
 {}
 
inline bool CTypeQualified::isConst () const
 { return _Const; }
inline bool CTypeQualified::isVolatile () const
 { return _Volatile; }
inline bool CTypeQualified::isRestrict () const
 { return _Restrict; }

inline void CTypeQualified::isConst (bool v)
 { _Const = v; }
inline void CTypeQualified::isVolatile (bool v)
 { _Volatile = v; }
inline void CTypeQualified::isRestrict (bool v)
 { _Restrict = v; }


} // namespace Puma

#endif /* __CTypeQualified_h__ */
