/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "player.h"
#include "globaldata.h"
#include "files.h"

GLOBALDATA::GLOBALDATA ()
{
	initialise ();
        sound = 1.0;
        name_above_tank = TRUE;
	colourDepth = 16;
	screenWidth = DEFAULT_SCREEN_WIDTH;
	screenHeight = DEFAULT_SCREEN_HEIGHT;
        width_override = height_override = 0;
        temp_screenWidth = screenWidth;
        temp_screenHeight = screenHeight;
	halfWidth = screenWidth / 2;
	halfHeight = screenHeight / 2;
        frames_per_second = FRAMES_PER_SECOND;
        #ifndef DOS
	cacheCirclesBG = 1;
        #endif
        #ifdef DOS
        cacheCirclesBG = 0;
        #endif
	ditherGradients = 1;
	detailedLandscape = 0;
	detailedSky = 0;
        colour_theme = 0.0;
	startmoney = 15000;
	turntype = TURN_RANDOM;
	skipComputerPlay = SKIP_HUMANS_DEAD;
	dataDir = DATA_DIR;
        os_mouse = 1.0;
        full_screen = false;
        tank_status[0] = 0;
	interest = 1.25;
	scoreHitUnit = 75;
	scoreSelfHit = 0;
	scoreUnitDestroyBonus = 5000;
	scoreUnitSelfDestroy = 0;
	scoreRoundWinBonus = 10000;
	sellpercent = 0.80;
        game_name[0] = '\0';
        load_game = 0.0;

	updates = new BOX[MAXUPDATES];
	if (!updates) {
		perror ("globaldata.cc: Failed allocating memory for updates in GLOBALDATA::GLOBALDATA");
		exit (1);
	}
	lastUpdates = new BOX[MAXUPDATES];
	if (!lastUpdates) {
		perror ("globaldata.cc: Failed allocating memory for lastUpdates in GLOBALDATA::GLOBALDATA");
		exit (1);
	}
	updateCount = 0;
	lastUpdatesCount = 0;

	players = new PLAYER*[MAXPLAYERS];
	if (!players) {
		perror ("globaldata.cc: Failed allocating memory for players in GLOBALDATA::GLOBALDATA");
		exit (1);
	}
	numPlayers = 0;
	rounds = 5;

	allPlayers = (PLAYER**)malloc (sizeof (PLAYER*));
	if (!allPlayers) {
		fprintf (stderr, "Failed allocating memory for players in globaldata.cc\n");
		exit (1);
	}

	for (int count = 0; count < 360; count++) {
		slope[count][0] = sin (count / (180 / PI));
		slope[count][1] = cos (count / (180 / PI));
	}
	slope[270][1] = 0;
}

// Following are config file definitions
#define	GFILE_LATEST_VERSION	6

#define GFILE_NUMPLAYERS	&numPlayers, sizeof (int), 1, file
#define	GFILE_OLDROUNDS		&rounds, sizeof (int), 1, file
#define	GFILE_ROUNDS		&rounds, sizeof (double), 1, file
#define	GFILE_DITHER		&ditherGradients, sizeof (double), 1, file
#define	GFILE_DETAILEDSKY	&detailedSky, sizeof (double), 1, file
#define	GFILE_DETAILEDLAND	&detailedLandscape, sizeof (double), 1, file
#define	GFILE_STARTMONEY	&startmoney, sizeof (double), 1, file
#define	GFILE_TURNTYPE		&turntype, sizeof (double), 1, file
#define	GFILE_INTEREST		&interest, sizeof (double), 1, file
#define	GFILE_SCOREROUNDWINBONUS	&scoreRoundWinBonus, sizeof (double), 1, file
#define	GFILE_SCOREHITUNIT		&scoreHitUnit, sizeof (double), 1, file
#define	GFILE_SCORESELFHIT		&scoreSelfHit, sizeof (double), 1, file
#define	GFILE_SCOREUNITDESTROYBONUS	&scoreUnitDestroyBonus, sizeof (double), 1, file
#define	GFILE_SCOREUNITSELFDESTROY	&scoreUnitSelfDestroy, sizeof (double), 1, file
#define	GFILE_ACCELERATEDAI	&skipComputerPlay, sizeof (double), 1, file
#define GFILE_SELLPERCENT	&sellpercent, sizeof(double), 1, file
#define GFILE_ENABLESOUND       &sound, sizeof(double), 1, file
#define GFILE_SCREENWIDTH       &screenWidth, sizeof(int), 1, file
#define GFILE_SCREENHEIGHT      &screenHeight, sizeof(int), 1, file
#define GFILE_OS_MOUSE          &os_mouse, sizeof(double), 1, file


#define	GFILE_VERSION_1(a)	a (GFILE_NUMPLAYERS);\
				a (GFILE_OLDROUNDS);\
				a (GFILE_DITHER);\
				a (GFILE_DETAILEDSKY);\
				a (GFILE_DETAILEDLAND);\
				a (GFILE_STARTMONEY);\
				a (GFILE_TURNTYPE);\
				a (GFILE_INTEREST);

#define	GFILE_VERSION_2(a)	a (GFILE_NUMPLAYERS);\
				a (GFILE_ROUNDS);\
				a (GFILE_DITHER);\
				a (GFILE_DETAILEDSKY);\
				a (GFILE_DETAILEDLAND);\
				a (GFILE_STARTMONEY);\
				a (GFILE_TURNTYPE);\
				a (GFILE_INTEREST);\
				a (GFILE_SCOREROUNDWINBONUS);\
				a (GFILE_SCOREHITUNIT);\
				a (GFILE_SCORESELFHIT);\
				a (GFILE_SCOREUNITDESTROYBONUS);\
				a (GFILE_SCOREUNITSELFDESTROY);

#define	GFILE_VERSION_3(a)	a (GFILE_NUMPLAYERS);\
				a (GFILE_ROUNDS);\
				a (GFILE_DITHER);\
				a (GFILE_DETAILEDSKY);\
				a (GFILE_DETAILEDLAND);\
				a (GFILE_STARTMONEY);\
				a (GFILE_TURNTYPE);\
				a (GFILE_INTEREST);\
				a (GFILE_SCOREROUNDWINBONUS);\
				a (GFILE_SCOREHITUNIT);\
				a (GFILE_SCORESELFHIT);\
				a (GFILE_SCOREUNITDESTROYBONUS);\
				a (GFILE_SCOREUNITSELFDESTROY);\
				a (GFILE_ACCELERATEDAI);

#define	GFILE_VERSION_4(a)	a (GFILE_NUMPLAYERS);\
				a (GFILE_ROUNDS);\
				a (GFILE_DITHER);\
				a (GFILE_DETAILEDSKY);\
				a (GFILE_DETAILEDLAND);\
				a (GFILE_STARTMONEY);\
				a (GFILE_TURNTYPE);\
				a (GFILE_INTEREST);\
				a (GFILE_SCOREROUNDWINBONUS);\
				a (GFILE_SCOREHITUNIT);\
				a (GFILE_SCORESELFHIT);\
				a (GFILE_SCOREUNITDESTROYBONUS);\
				a (GFILE_SCOREUNITSELFDESTROY);\
				a (GFILE_ACCELERATEDAI);\
				a (GFILE_SELLPERCENT);

#define GFILE_VERSION_5(a)      a (GFILE_NUMPLAYERS);\
                                a (GFILE_ROUNDS);\
                                a (GFILE_DITHER);\
                                a (GFILE_DETAILEDSKY);\
                                a (GFILE_DETAILEDLAND);\
                                a (GFILE_STARTMONEY);\
                                a (GFILE_TURNTYPE);\
                                a (GFILE_INTEREST);\
                                a (GFILE_SCOREROUNDWINBONUS);\
                                a (GFILE_SCOREHITUNIT);\
                                a (GFILE_SCORESELFHIT);\
                                a (GFILE_SCOREUNITDESTROYBONUS);\
                                a (GFILE_SCOREUNITSELFDESTROY);\
                                a (GFILE_ACCELERATEDAI);\
                                a (GFILE_SELLPERCENT);\
                                a (GFILE_ENABLESOUND);\
                                a (GFILE_SCREENWIDTH);\
                                a (GFILE_SCREENHEIGHT);

#define GFILE_VERSION_6(a)      a (GFILE_NUMPLAYERS);\
                                a (GFILE_ROUNDS);\
                                a (GFILE_DITHER);\
                                a (GFILE_DETAILEDSKY);\
                                a (GFILE_DETAILEDLAND);\
                                a (GFILE_STARTMONEY);\
                                a (GFILE_TURNTYPE);\
                                a (GFILE_INTEREST);\
                                a (GFILE_SCOREROUNDWINBONUS);\
                                a (GFILE_SCOREHITUNIT);\
                                a (GFILE_SCORESELFHIT);\
                                a (GFILE_SCOREUNITDESTROYBONUS);\
                                a (GFILE_SCOREUNITSELFDESTROY);\
                                a (GFILE_ACCELERATEDAI);\
                                a (GFILE_SELLPERCENT);\
                                a (GFILE_ENABLESOUND);\
                                a (GFILE_SCREENWIDTH);\
                                a (GFILE_SCREENHEIGHT);\
                                a (GFILE_OS_MOUSE);



#define	GFILE_WRITE_LATEST	GFILE_VERSION_6(fwrite)
#define	GFILE_READ_VERSION_1	GFILE_VERSION_1(fread)
#define	GFILE_READ_VERSION_2	GFILE_VERSION_2(fread)
#define	GFILE_READ_VERSION_3	GFILE_VERSION_3(fread)
#define	GFILE_READ_VERSION_4	GFILE_VERSION_4(fread)
#define GFILE_READ_VERSION_5    GFILE_VERSION_5(fread)
#define GFILE_READ_VERSION_6    GFILE_VERSION_6(fread)


/*
This function saves the global data to a text file. If all goes
well, TRUE is returned, on error, FALSE is returned.
-- Jesse
*/
int GLOBALDATA::saveToFile_Text( FILE *file)
{
   if (! file) return FALSE;

   
   screenWidth = (int) temp_screenWidth;
   screenHeight = (int) temp_screenHeight;

   fprintf(file, "*GLOBAL*\n");

   fprintf(file, "NUMPLAYERS=%d\n", numPlayers);
   fprintf(file, "ROUNDS=%lf\n", rounds);
   fprintf(file, "DITHER=%lf\n", ditherGradients);
   fprintf(file, "DETAILEDSKY=%lf\n", detailedSky);
   fprintf(file, "DETAILEDLAND=%lf\n", detailedLandscape);
   fprintf(file, "STARTMONEY=%lf\n", startmoney);
   fprintf(file, "TURNTYPE=%lf\n", turntype);
   fprintf(file, "INTEREST=%lf\n", interest);
   fprintf(file, "SCOREROUNDWINBONUS=%lf\n", scoreRoundWinBonus);
   fprintf(file, "SCOREHITUNIT=%lf\n", scoreHitUnit);
   fprintf(file, "SCOREUNITDESTROYBONUS=%lf\n", scoreUnitDestroyBonus);
   fprintf(file, "SCOREUNITSELFDESTROY=%lf\n", scoreUnitSelfDestroy);
   fprintf(file, "ACCELERATEDAI=%lf\n", skipComputerPlay);
   fprintf(file, "SELLPERCENT=%lf\n", sellpercent);
   fprintf(file, "ENABLESOUND=%lf\n", sound);
   fprintf(file, "SCREENWIDTH=%d\n", screenWidth);
   fprintf(file, "SCREENHEIGHT=%d\n", screenHeight);
   fprintf(file, "OSMOUSE=%lf\n", os_mouse);
   fprintf(file, "NUMPERMANENTPLAYERS=%d\n", numPermanentPlayers);
   fprintf(file, "LANGUAGE=%lf\n", language);
   fprintf(file, "COLOURTHEME=%lf\n", colour_theme);
   fprintf(file, "FRAMES=%lf\n", frames_per_second);
   fprintf(file, "***\n");
   return TRUE;
}

/*
This function loads global settings from a text
file. The function returns TRUE on success and FALSE if
any erors are encountered.
-- Jesse
*/
int GLOBALDATA::loadFromFile_Text (FILE *file)
{
    char line[MAX_CONFIG_LINE];
    int equal_position, line_length;
    char field[MAX_CONFIG_LINE], value[MAX_CONFIG_LINE];
    char *result = NULL;
    bool done = false;
    double sound_bookmark = 1.0;

    if (! sound)
        sound_bookmark = sound;

    // read until we hit line "*ENV*" or "***" or EOF
    do
    {
      result = fgets(line, MAX_CONFIG_LINE, file);
      if (! result)     // eof
         return FALSE;
      if (! strncmp(line, "***", 3) )     // end of record
         return FALSE;
    } while ( strncmp(line, "*GLOBAL*", 5) );     // read until we hit new record

      while ( (result) && (!done) )
      {
       // read a line
       memset(line, '\0', MAX_CONFIG_LINE);
       result = fgets(line, MAX_CONFIG_LINE, file);
     if (result)
       {
          // if we hit end of the record, stop
          if (! strncmp(line, "***", 3) )
          {
            return TRUE;
          }
          // find equal sign
          line_length = strlen(line);
          // strip newline character
          if ( line[line_length - 1] == '\n')
          {
               line[line_length - 1] = '\0';
               line_length--;
          }
          equal_position = 1;
          while ( ( equal_position < line_length) && (line[equal_position] != '=') )
              equal_position++;
          // make sure we have valid equal sign

          if ( equal_position <= line_length )
          {
              // seperate field from value
             memset(field, '\0', MAX_CONFIG_LINE);
             memset(value, '\0', MAX_CONFIG_LINE);
             strncpy(field, line, equal_position);
             strcpy(value, & (line[equal_position + 1]));
             if (! strcasecmp(field, "numplayers") )
                sscanf(value, "%d", &numPlayers);
             else if (! strcasecmp(field, "rounds") )
                sscanf(value, "%lf", &rounds);
             else if (! strcasecmp(field, "dither"))
                sscanf(value, "%lf", &ditherGradients);
             else if (! strcasecmp(field, "detailedsky"))
                sscanf(value, "%lf", &detailedSky);
             else if (! strcasecmp(field, "detailedland"))
                sscanf(value, "%lf", &detailedLandscape);
             else if (! strcasecmp(field, "startmoney"))
                sscanf(value, "%lf", &startmoney);
             else if (! strcasecmp(field, "turntype"))
                sscanf(value, "%lf", &turntype);
             else if (! strcasecmp(field, "interest"))
                sscanf(value, "%lf", &interest);
             else if (! strcasecmp(field, "scoreroundwinbonus"))
                sscanf(value, "%lf", &scoreRoundWinBonus);
             else if (! strcasecmp(field, "scorehitunit"))
                sscanf(value, "%lf", &scoreHitUnit);
             else if (! strcasecmp(field, "scoreunitdestroybonus"))
                sscanf(value, "%lf", &scoreUnitDestroyBonus);
             else if (! strcasecmp(field, "scoreunitselfdestroy"))
                sscanf(value, "%lf", &scoreUnitSelfDestroy);
             else if (! strcasecmp(field, "acceleratedai"))
                sscanf(value, "%lf", &skipComputerPlay);
             else if (! strcasecmp(field, "sellpercent"))
                sscanf(value, "%lf", &sellpercent);
             else if (! strcasecmp(field, "enablesound"))
                sscanf(value, "%lf", &sound);
             else if (! strcasecmp(field, "screenwidth"))
                sscanf(value, "%d", &screenWidth);
             else if (! strcasecmp(field, "screenheight"))
                sscanf(value, "%d", &screenHeight);
             else if (! strcasecmp(field, "OSMOUSE"))
                sscanf(value, "%lf", &os_mouse);
             else if (! strcasecmp(field, "numpermanentplayers"))
                sscanf(value, "%d", &numPermanentPlayers);
             else if (! strcasecmp(field, "language") )
                sscanf(value, "%lf", &language);
             else if (! strcasecmp(field, "colourtheme") )
                sscanf(value, "%lf", &colour_theme);
             else if (! strcasecmp(field, "frames") )
                sscanf(value, "%lf", &frames_per_second);
         }    // end of found field=value line

      }     // end of read a line properly
     }     // end of while not done
    if (! sound_bookmark)
           sound = sound_bookmark;

    if (width_override)
           screenWidth = width_override;
    if (height_override)
           screenHeight = height_override;

    halfWidth = screenWidth / 2;
    halfHeight = screenHeight / 2;

    if (skipComputerPlay > SKIP_HUMANS_DEAD)
       skipComputerPlay = SKIP_HUMANS_DEAD;

   return TRUE;
}




int GLOBALDATA::saveToFile (FILE *file)
{
	int version = GFILE_LATEST_VERSION;
	if (!file)
		return (-1);

        screenWidth = (int) temp_screenWidth;
        screenHeight = (int) temp_screenHeight;

	fwrite (&version, sizeof (int), 1, file);

	GFILE_WRITE_LATEST

	return (ferror (file));
}


/*
This function loads the global options from the config file.
A note on the sound thing going on: Sound is ON by default,
however, before we get here, Atanks checks the command line
to see if we should turn sound OFF. So, if sound is OFF we
we get here, we save that over-ride from the command line.
However, if the sound is ON when we get here, we leave it
ON.
-- Jesse
*/
int GLOBALDATA::loadFromFile (FILE *file)
{
	int version;
        double sound_bookmark = 1.0;

        if (! sound)
            sound_bookmark = sound;

	if (!file)
		return (-1);

	fread (&version, sizeof (int), 1, file);

	switch (version) {
		case 1:
			GFILE_READ_VERSION_1;
			break;
		case 2:
			GFILE_READ_VERSION_2;
			break;
		case 3:
			GFILE_READ_VERSION_3;
			break;
		case 4:
			GFILE_READ_VERSION_4;
			break;
                case 5:
                        GFILE_READ_VERSION_5;
                        break;
                case 6:
                        GFILE_READ_VERSION_6;
                        break;
		default:
			break;
	}

        if (! sound_bookmark)
           sound = sound_bookmark;

        if (width_override)
           screenWidth = width_override;
        if (height_override)
           screenHeight = height_override;

        halfWidth = screenWidth / 2;
        halfHeight = screenHeight / 2;

	return (ferror (file));
}

void GLOBALDATA::initialise ()
{
	numTanks = 0;
}

void GLOBALDATA::addPlayer (PLAYER *player)
{
	if (numPlayers < MAXPLAYERS) {
		players[numPlayers] = player;
		numPlayers++;
		if ((int)player->type == HUMAN_PLAYER) {
			numHumanPlayers++;
			computerPlayersOnly = FALSE;
		}
	}
}

void GLOBALDATA::removePlayer (PLAYER *player)
{
	int fromCount = 0;
	int toCount = 0;

	for (; fromCount < numPlayers; fromCount++) {
		if (player != players[fromCount]) {
			if ((int)player->type == HUMAN_PLAYER) {
				numHumanPlayers--;
				if (numHumanPlayers == 0) {
					computerPlayersOnly = TRUE;
				}
			}
			toCount++;
		}
		players[toCount] = players[fromCount];
	}
	numPlayers -= fromCount - toCount;
}

PLAYER *GLOBALDATA::getNextPlayer (int *playerCount)
{
	(*playerCount)++;
	if (*playerCount >= numPlayers)
		*playerCount = 0;
	return (players[*playerCount]);
}

PLAYER *GLOBALDATA::createNewPlayer (ENVIRONMENT *env)
{
	PLAYER **reallocatedPlayers;
	PLAYER *player;

	reallocatedPlayers = (PLAYER**)realloc (allPlayers, sizeof (PLAYER*) * (numPermanentPlayers + 1));
	if (reallocatedPlayers != NULL) {
		allPlayers = reallocatedPlayers;
	} else {
		perror ("atanks.cc: Failed allocating memory for reallocatedPlayers in GLOBALDATA::createNewPlayer");
		exit (1);
	}
	player = new PLAYER (this, env);
	if (!player) {
		perror ("globaldata.cc: Failed allocating memory for player in GLOBALDATA::createNewPlayer");
		exit (1);
	}
	allPlayers[numPermanentPlayers] = player;
	numPermanentPlayers++;

	return (player);
}

void GLOBALDATA::destroyPlayer (PLAYER *player)
{
	int fromCount = 0;
	int toCount = 0;

	for (; fromCount < numPermanentPlayers; fromCount++) {
		if (allPlayers[fromCount] != player) {
			allPlayers[toCount] = allPlayers[fromCount];
			toCount++;
		}
	}
	numPermanentPlayers--;
}
