/*\  XMMS - Cross-platform multimedia player
|*|  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas,
|*|                           Thomas Nilsson and 4Front Technologies
|*|
|*|  Network Audio System driver by Willem Monsuwe (willem@stack.nl)
|*|
|*|  This program is free software; you can redistribute it and/or modify
|*|  it under the terms of the GNU General Public License as published by
|*|  the Free Software Foundation; either version 2 of the License, or
|*|  (at your option) any later version.
|*|
|*|  This program is distributed in the hope that it will be useful,
|*|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|  GNU General Public License for more details.
|*|
|*|  You should have received a copy of the GNU General Public License
|*|  along with this program; if not, write to the Free Software
|*|  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\*/
#ifndef NAS_H
#define NAS_H

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <errno.h>
#include <audio/audiolib.h>

#define MAX(a, b)	(((a) > (b)) ? (a) : (b))
#define MIN(a, b)	(((a) < (b)) ? (a) : (b))

#define nas_mutex_lock()	do { \
	DPRINTF("locking nas_mutex on line %d\n", __LINE__); \
	pthread_mutex_lock(&nas_mutex); \
} while (0)
#define nas_mutex_unlock()	do { \
	pthread_mutex_unlock(&nas_mutex); \
	DPRINTF("nas_mutex unlocked on line %d\n", __LINE__); \
} while (0)

#if DSP_DEBUG == 1

static char *nas_event_types[] = {
	"Undefined",
	"Undefined",
	"ElementNotify",
	"GrabNotify",
	"MonitorNotify",
	"BucketNotify",
	"DeviceNotify"
};

static char *nas_elementnotify_kinds[] = {
	"LowWater",
	"HighWater",
	"State",
	"Unknown"
};

static char *nas_states[] = {
	"Stop",
	"Start",
	"Pause",
	"Any"
};

static char *nas_reasons[] = {
	"User",
	"Underrun",
	"Overrun",
	"EOF",
	"Watermark",
	"Hardware",
	"Any"
};

static char* nas_reason(unsigned int reason)
{
	if (reason > 6) reason = 6;
	return nas_reasons[reason];
}

static char* nas_elementnotify_kind(unsigned int kind)
{
	if (kind > 2) kind = 3;
	return nas_elementnotify_kinds[kind];
}

static char* nas_event_type(unsigned int type)
{
	if (type > 6) type = 0;
	return nas_event_types[type];
}

static char* nas_state(unsigned int state)
{
	if (state > 3) state = 3;
	return nas_states[state];
}

#define DPRINTF(format, args...)	fprintf(stderr, format, ## args); \
					fflush(stderr)
#else
#define DPRINTF(format, args...)
#endif

/*JET*/
typedef unsigned int AFormat;

typedef struct {
	char* server;
	int bufsize;
} NASConfig;

extern NASConfig nas_cfg;

void nas_init(void);

int nas_open(AFormat fmt, int rate, int nch);
void nas_close(void);
void nas_reset(void);

void nas_set_format(AFormat fmt);
void nas_set_rate(int rate);
void nas_set_nch(int nch);

int nas_write(char *ptr, int length);
int nas_getdelay(AFormat fmt, int rate, int nch);

int nas_set_volume (int volume);
int nas_get_volume ();

int nas_frag_count();
int nas_free_frags();
int nas_frag_size();
#endif
