#!/usr/bin/env python

# Copyright (C) Andrew Mitchell 2006

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.

#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
############################################################################

## client side: edit nsswitch.conf
## see /usr/share/doc/nis/nis.debian.howto.gz
from AuthTool import nsswitch, passwd, config, authtools

config.methods['NISPlus'] = 'NIS/NIS+ Authentication'

class NISPlusConfig(authtools.IAuthConfig):
    name = "NISPlus"
    packages = ["nis"] #already depends on netbase & portmap
    requires = []
    display = True

    nss_switch = {'passwd':'compat','group':'compat','shadow':'compat'}
    
    
    def __init__(self, authconfig):
        self.cfg = authconfig
        self.db = authtools.Debconf()
        
        # Various debconf settings for nis.postinst
        # nis/domain
        


    def enable(self):
        # setup /etc/yp.conf (debconf)
        # setup /etc/nsswitch.conf
        
        # *NOTE NOTE NOTE* - if you put a servername in /etc/yp.conf, make
        # sure the server is also in /etc/hosts, or put it in in dotted-quad
        # notation (12.34.56.78). Otherwise if your system boots and the
        # network is not yet up or DNS isn't reachable, ypserv cannot resolve
        # the servers in /etc/yp.conf and will hang!


        nss = nsswitch.NSSwitchConfig()
        # Make sure compat entries are in /etc/nsswitch.conf
        nss.enable('compat')
        nss.save()    

        pwd = passwd.PasswdConfig()
        pwd.enable('nis')
        pwd.save()    
        grp = passwd.GroupConfig()
        grp.enable('nis')
        grp.save()    
        shd = passwd.ShadowConfig()
        shd.enable('nis')
        shd.save()    



    
