
/* autopano-sift, Automatic panorama image creation
 * Copyright (C) 2004 -- Sebastian Nowozin
 *
 * This program is free software released under the GNU General Public
 * License, which is included in this software package (doc/LICENSE).
 */

/* ShowTwo.cs
 *
 * Two image keypoint file correlation and display utility.
 *
 * (C) Copyright 2004 -- Sebastian Nowozin (nowozin@cs.tu-berlin.de)
 *
 * "This software is provided for non-commercial use only. The University of
 * British Columbia has applied for a patent on the SIFT algorithm in the
 * United States. Commercial applications of this software may require a
 * license from the University of British Columbia."
 * For more information, see the LICENSE file supplied with the distribution.
 */

using Gtk;
using GtkSharp;
using System;
using System.IO;
using System.Collections;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;


public class ShowTwo
{
	public static void Main (string[] args)
	{
		if (args.Length < 2 || args.Length > 3) {
			Console.WriteLine ("Display matches between two images\n");

			Console.WriteLine ("usage: showtwo.exe keyfile1 keyfile2 [bestCount]\n");
			Console.WriteLine ("keyfile<n>: Keypoint file for the first/second image.");
			Console.WriteLine ("    The keypoint files can be compressed by using the \".gz\" extension.");
			Console.WriteLine ("bestCount: (optional) Maximum number of matches displayed.");
			Console.WriteLine ("");

			return;
		}

		Application.Init ();

		Window win = new Window ("Image match display program");
		win.DefaultSize = new Gdk.Size (400, 300);
		win.DeleteEvent += new DeleteEventHandler (Window_Delete);

		KeypointXMLList keys1 = KeypointXMLReader.ReadComplete (args[0]);
		Console.WriteLine ("Keyset 1 loaded.");
		KeypointXMLList keys2 = KeypointXMLReader.ReadComplete (args[1]);
		Console.WriteLine ("Keyset 2 loaded.");

		string file1 = keys1.ImageFile;
		string file2 = keys2.ImageFile;
		Console.WriteLine ("file1: {0}, file2: {1}", file1, file2);

		MatchKeys mk = new MatchKeys ();
		//ArrayList matches = mk.FindMatches (keys1, keys2);
		ArrayList matches = mk.FindMatchesBBF (keys1.Arr, keys2.Arr);
		matches = MatchKeys.FilterJoins (matches);
		if (args.Length > 2)
			MatchKeys.FilterNBest (matches, Int32.Parse (args[2]));

		DisplayTwoImages pic = new DisplayTwoImages (file1, file2);

		// Print matches to stdout and draw match lines in picture
		Match.MatchWeighter mw = new Match.MatchWeighter ();

		Console.WriteLine ("\nFinal matches:");
		foreach (Match m in matches) {
			Console.WriteLine ("({0},{1}) ({2},{3}) {4}, 2nd: {5}, weight {6}",
				(int)(m.Kp1.X + 0.5), (int)(m.Kp1.Y + 0.5),
				(int)(m.Kp2.X + 0.5), (int)(m.Kp2.Y + 0.5),
				m.Dist1, m.Dist2, mw.OverallFitness (m));

			pic.DrawLine ((int) (m.Kp1.X + 0.5), (int) (m.Kp1.Y + 0.5),
				(int) (pic.XDiv + m.Kp2.X + 0.5), (int) (pic.YDiv + m.Kp2.Y + 0.5),
				255, 0, 0);
		}

		win.Add (new Image (pic.Pbuf));
		win.ShowAll ();
		Application.Run ();
	}

	static void Window_Delete (object obj, DeleteEventArgs args)
	{
		Application.Quit ();
		args.RetVal = true;
	}
}


