# Arch Perl library, Copyright (C) 2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::cset;
use base 'AXP::Command';

use Arch::Session;

sub infoline {
	"operate on arch changeset"
}

sub helptext {
	my $self = shift;
	my $prefix = $self->{prefix};

	return $self->SUPER::helptext . qq{
		Note, the changeset parameter for '$prefix' commands may be
		specified in one of the following ways:

			/some/changeset/dir/say/,,undo-1
			/some/project/tree   (operate on tree changes)
			my\@archive/my--main--0--revision
			/some/changeset.tar.gz
			/some/tree.tar.gz
			http://some.where/here/changeset.tar.gz
			http://some.where/here/tree.tar.gz
	}
}

sub changeset ($;$) {
	my $self = shift;
	my $arg = shift;

	unless ($self->{changeset}) {
		$arg ||= shift @ARGV;
		$self->{changeset} =
			Arch::Session->instance->get_specified_changeset($arg);
	}	
	return $self->{changeset};
}

1;
