# Arch Perl library, Copyright (C) 2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::triggers::delete;
use base 'AXP::Command::triggers';

use Arch::Util qw(remove_dir);

sub optusage {
	"[options] limit ..."
}

sub infoline {
	"delete a trigger from the watch list"
}

sub options {
	(
		__PACKAGE__->limits_option,
		__PACKAGE__->verbose_option,
		__PACKAGE__->quiet_option,
	)
}

sub helptext {
	q{
		This command deletes the previously added triggers completely.
		The arguments should be one or more trigger limit (or trigger
		number) as shown by 'list'.
	}
}

sub execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	my @names = @ARGV;
	die "Please specify one or more limits to delete, or -l\n"
		unless @names || $opt{limits};

	$ENV{DEBUG} = 1 if $opt{verbose};

	foreach my $name (@names) {
		my $trigger = $self->load_trigger($name);

		remove_dir($trigger->{dir});

		print "* trigger for $trigger->{name} is deleted\n"
			unless $opt{quiet};
	}
}

1;
