/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.SocketException;
import java.util.Date;
import nz.net.catalyst.IClient;
import nz.net.catalyst.Log;
import nz.net.catalyst.lucene.server.Dialogue;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;
import nz.net.catalyst.lucene.server.XMLHelper;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public class Session
implements IPackage,
IClient {
    private static final String ERROR = "Error";

    public void communicate(BufferedReader input, PrintWriter output, String id) {
        Log.info("---Starting session---");
        long sessionStartTime = System.currentTimeMillis();
        String line = null;
        String serial = null;
        boolean isXML = false;
        try {
            try {
                line = input.readLine().trim();
                if (line != null && line.startsWith("<")) {
                    isXML = true;
                    StringBuffer sb = new StringBuffer();
                    do {
                        Log.debug("XML Line being processed: " + line);
                        sb.append(line);
                    } while (!XMLHelper.isEndTag(line) && (line = input.readLine()) != null);
                    try {
                        Log.debug("About to strip invalid(high byte) characters");
                        String unstripped = sb.toString();
                        StringBuffer stripped = new StringBuffer();
                        int i = 0;
                        while (i < unstripped.length()) {
                            char c = unstripped.charAt(i);
                            char char_value = c;
                            if (char_value < '\u0080') {
                                if (char_value > '\u001f') {
                                    stripped.append(c);
                                } else {
                                    Log.debug(" - replacing character with space:" + char_value + ": char: " + c);
                                    stripped.append(' ');
                                }
                            } else {
                                Log.debug(" - stripping character with value:" + char_value + ": char: " + c);
                            }
                            ++i;
                        }
                        Log.debug("About to parse XML input...");
                        Document doc = DocumentHelper.parseText((String)stripped.toString());
                        Log.debug("Input parsed as XML successfully!");
                        Transmission transmission = new XMLHelper().getTransmission(doc);
                        serial = transmission.getSerial();
                        Log.debug("Request body interpreted...");
                        Dialogue dialogue = Dialogue.create(transmission, input, output);
                        dialogue.process();
                    }
                    catch (DocumentException e) {
                        Log.warn("XML Parse Error.  Your xml is invalid, sorry.");
                        Log.warn(e.getMessage());
                        Transmission response = new Transmission(ECommand.ERROR);
                        response.add(ERROR, "XML Parse Error: " + e.getMessage());
                        response.setXML(true);
                        response.write(output);
                    }
                } else {
                    Dialogue dialogue;
                    Log.debug("about to read LuceneProtocol v1.0");
                    if (line == null) {
                        Session.error(output, "Invalid input, trying to process null.");
                    }
                    if ((dialogue = Dialogue.create(line, input, output)) == null) {
                        Session.error(output, "Expecting command, found: " + line);
                    } else {
                        Log.debug("About to process LuceneProtocol v1.0 Dialogue: " + dialogue);
                        dialogue.process();
                        dialogue = null;
                    }
                }
            }
            catch (SocketException e) {
                Log.error("Client Timed Out: No data sent within timeout period.");
                Log.debug("Last line: " + line);
            }
            catch (InterruptedIOException e) {
                Log.error("Client Timed Out: No data sent within timeout period.");
                Log.debug("Last line: " + line);
            }
            catch (IOException e) {
                Log.error("Error when reading from socket:" + e.getMessage());
                Log.debug("Can be caused by invalid encoding setting and multi-byte characters");
                throw new RuntimeException("I/O Error on \"" + id + '\"', e);
            }
            catch (OutOfMemoryError e) {
                Log.error("Ran out of memory while trying to complete Client Request.");
                Transmission transmission = new Transmission(ECommand.ERROR);
                if (serial != null) {
                    transmission.add("Serial", serial);
                }
                transmission.add(ERROR, "Ran out of memory while trying to complete request.\n Suggest no sorting or limiting the number of results returned.");
                if (isXML) {
                    transmission.setXML(true);
                }
                transmission.write(output);
                System.err.println(new Date() + " - Ran out of memory.");
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
                output = null;
                input = null;
            }
            catch (Exception exception) {}
            long l = System.currentTimeMillis();
            Log.info("===Ended session=== (Total Time: " + (l - sessionStartTime) + "ms)");
        }
        line = null;
    }

    static void error(PrintWriter output, String message) {
        Transmission transmission = new Transmission(ECommand.ERROR);
        transmission.add(ERROR, message);
        transmission.write(output);
    }
}

