/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nz.net.catalyst.Util;

public class ELog
implements Comparable,
Serializable {
    static final long serialVersionUID = 0L;
    private final int level;
    private final transient String[] names;
    private static int nextOrdinal = 0;
    private final int ordinal = nextOrdinal++;
    public static final ELog DEBUG = new ELog(7, "DEBUG");
    public static final ELog INFO = new ELog(6, "INFO INFORMATION");
    public static final ELog NOTICE = new ELog(5, "NOTICE");
    public static final ELog WARNING = new ELog(4, "WARNING");
    public static final ELog ERROR = new ELog(3, "ERROR");
    public static final ELog CRITICAL = new ELog(2, "CRITICAL");
    public static final ELog ALERT = new ELog(1, "ALERT");
    public static final ELog FATAL = new ELog(0, "FATAL EMERGENCY");
    private static final ELog[] PRIVATE_VALUES = new ELog[]{DEBUG, INFO, NOTICE, WARNING, ERROR, CRITICAL, ALERT, FATAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));
    public static final Map BY_NAME = new HashMap();

    static {
        int i = 0;
        while (i < PRIVATE_VALUES.length) {
            ELog elog = PRIVATE_VALUES[i];
            int j = 0;
            while (j < elog.names.length) {
                BY_NAME.put(elog.names[j].toUpperCase(), elog);
                ++j;
            }
            ++i;
        }
    }

    private ELog(int level, String name) {
        this.level = level;
        this.names = Util.split(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ELog[" + this.names[0]);
        int i = 1;
        while (i < this.names.length) {
            sb.append("/" + this.names[i]);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public int compareTo(Object o) {
        return this.ordinal - ((ELog)o).ordinal;
    }

    public boolean lessThan(Object o) {
        return this.compareTo(o) < 0;
    }

    public boolean greaterThan(Object o) {
        return this.compareTo(o) > 0;
    }

    private Object readResolve() throws ObjectStreamException {
        return PRIVATE_VALUES[this.ordinal];
    }

    public String getName() {
        return this.names[0];
    }

    public static ELog getByName(String name) {
        return (ELog)BY_NAME.get(name.toUpperCase());
    }
}

