#!/bin/bash
################################################
#                                              #
#    Comprehensive Lucene Startup Script       #
#                                              #
# This script is called by the init.d.lucene   #
# script so the luceneserver is wrapped as a   #
# daemon and the stop/start commands can be    #
# used.                                        #
# Please see init.d.lucene for more info.      #
################################################
export LUCENE_ROOT=/lucene
JAVA=/usr/local/java/jre/bin/java
SERVER=production
if [ "$1" != "" ]; then
  SERVER=$1
fi

# Read the globals file for this server. This will define
# the  $LUCENE_LIBS env variable used below..
. ${LUCENE_ROOT}/${SERVER}/etc/globals

LOGFILE=${LUCENE_ROOT}/${SERVER}/log/lucene.log
ERRFILE=${LUCENE_ROOT}/${SERVER}/log/lucene.err
PIDFILE=/var/run/lucene/lucene.$SERVER.pid

PATH="${PATH}:${JAVA_HOME:=/usr/local/java/jre}/bin"
export JAVA_HOME PATH

CLASSPATH=

for path in ${LUCENE_LIBS}/*
  do
    CLASSPATH="$CLASSPATH:$path"
  done
export CLASSPATH

echo "" >>$LOGFILE
echo "++++++++++++++++++++++++++++++" >> $LOGFILE
echo "Using classpath: ${CLASSPATH}" >> $LOGFILE
echo "++++++++++++++++++++++++++++++" >> $LOGFILE
echo "Lucene Server ($SERVER) Startup" `date` >>$LOGFILE
echo "Lucene Server ($SERVER) Startup" `date` >>$ERRFILE

$JAVA \
  \
-Dnz.net.catalyst.lucene.server.Server.config=${LUCENE_ROOT}/${SERVER}/etc/Server.config \
nz.net.catalyst.lucene.server.Server "$@" >>$LOGFILE 2>>$ERRFILE & 
PID=$!
echo "$PID" >$PIDFILE
