#!/bin/bash
# Remove a MS-SQL database for an Axyl website.

# NOTE: This is not normally run standalone. The main DB installation
# script 'install/remove-db.sh normally runs this.
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# The database type this remove script is for. This is just
# for messages and display..
DBTYPE="MS-SQL"

# INCOMING PARAMETERS
#  $1  - DBNAME
#  $2  - DBUSER
#  $3  - DBPASSWD ('none' means a blank password)
#  $4  - DBHOST ('direct' means a local database server)
#  $5  - DBPORT
DBNAME=""
DBUSER=""
DBPASSWD=""
DBHOST=""
DBPORT=5432

POS=0
while [ $# -gt 0 ] ; do
  POS=`expr $POS + 1`
  case $POS in
    1)  DBNAME=$1
        ;;
    2)  DBUSER=$1
        ;;
    3)  DBPASSWD=$1
        ;;
    4)  DBHOST=$1
        ;;
    5)  DBPORT=$1
        ;;
  esac
  shift
done

if [ "$DBNAME" = "" -o "$DBUSER" = "" ]
then
  echo "ERROR: $DBTYPE remove-db.sh: parameters."
  echo "usage: remove-db.sh dbname dbuser [dbpasswd] [dbhost] [dbport]"
  exit 1
fi

echo " $DBTYPE database - removal"
echo " database name: $DBNAME"
echo " connecting as: $DBUSER"
[ "$DBPASSWD" != "none" ] && echo " password: $DBPASSWD"
[ "$DBHOST" != "direct" ] && echo " remote host: $DBHOST"
[ "$DBHOST" != "direct" ] && echo " port: $DBPORT"
echo ""

# Optional host settings for remotely accessed databases..
HOSTOPTS=""
[ "$DBHOST" != "direct" ] && HOSTOPTS="--host $DBHOST --port $DBPORT"

# We require Postgres to be locally installed, at least as postgresql-client
# even if no servers are created locally. This is based on the standard
# Debian location, with a few likely fallbacks.

# Detect database, and set up database vars. This set up the following
# variables:
# 

. ${AXYL_HOME}/db/oracle/detect-db.sh $DBNAME $DBUSER $DBPASSWD $DBHOST $DBPORT

# Now set paths to our executables


# Now do the business..
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# REMOVE
echo ""
echo "*********************************************************************"
echo "IMPORTANT NOTICE!"
echo "You have chosen a database type which does not currently have an"
echo "Axyl db remover. At the present time we only provide an automatic"
echo "removal process for Postgresql."
echo ""
echo "*********************************************************************"
echo -n "[ENTER] to continue.."
read ANS

# END