<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    application.php                                         */
/* Author:      Paul Waite                                              */
/* Description: Main include file for the application. Mainly used      */
/*              to set the sub-directory that the Axyl library resides  */
/*              in. Also used to define user-specific stuff.            */
/*                                                                      */
/* ******************************************************************** */
/**
* THE AXYL LIBRARY DIRECTORY
*
* You can either leave this commented out, and let Axyl find it with
* the code just below, or force it here. The default is 'lib', however
* you might need to change this if it clashes with an existing directory.
*
* NOTE: This library directory must be specified as an absolute path.
*       It is usually defined as part of the Apache VirtualHost with
*       lines like:
*         SetEnv LIBDIR /path/to/axyl/lib
*/
//$LIBDIR = "/path/to/axyl/lib";
// -----------------------------------------------------------------------
// Document root is undefined for command-line scripts..
$DOCUMENT_ROOT = $_SERVER["DOCUMENT_ROOT"];
if (empty($DOCUMENT_ROOT)) {
  $DOCUMENT_ROOT = getcwd();
}
// -----------------------------------------------------------------------
/**
* AXYL LIBRARY LOCATOR
* If not defined above, sniff the Axyl library. We only allow for the
* basic possibilities, as listed in the below possibles array. These
* are relative to the website root directory.
*
*/
if (!isset($LIBDIR)) {
  $LIBDIR_POSSIBLES = array("lib", "library", "axyl");
  foreach ($LIBDIR_POSSIBLES as $testdir) {
    if (is_dir("$DOCUMENT_ROOT/$testdir")) {
      $LIBDIR = "/$testdir";
      break;
    }
  }
  // Failure is not an option..
  if (!isset($LIBDIR)) {
    die("could not locate Axyl library in document root $DOCUMENT_ROOT/");
  }
}

// -----------------------------------------------------------------------
/* CUSTOM USER AUTHENTICATION */
/**
 * Here you can define a custom function for authenticating a user password.
 * After doing this go to the Control Panel and set the password encryption
 * to the 'Custom' setting so that the system will use this function.
 * @param string $submitted_passwd The password as submitted by the user.
 * @param string $actual_passwd The actual (possibly encoded) password stored.
 * @return boolean True if the submitted password is good, else false
 */
function custom_authenticate_password($submitted_passwd, $actual_passwd) {
  return ($submitted_passwd === $actual_passwd);
}
/**
 * Here you can define a custom function for generating a user password.
 * After doing this go to the Control Panel and set the password encryption
 * to the 'Custom' setting so that the system will use this function.
 * @param string $password The un-encrypted password.
 * @param string $salt Optional salt for salted md5 encrypted passwords
 * @return string The encrypted password.
 */
function custom_generate_password($password, $salt="") {
  return ($password);
}

// -----------------------------------------------------------------------
/*
* THE RESPONSE OBJECT
* This module contains all the information, methods, and parameters
* required to co-ordinate the response to the browser request. It
* creates and initialises the $RESPONSE object from your application.xml
* configuration file.
*/
include_once("response-defs.php");

// -----------------------------------------------------------------------
// Check database is defined for remote authentication..
if (isset($RESPONSE) && $USER_AUTH_DBNAME != NOT_MAPPED) {
  if (!$RESPONSE->select_database($USER_AUTH_DBNAME)) {
    log_sys("remote authentication DB '$USER_AUTH_DBNAME' failed "
          . "test connection: is it defined in application.xml?"
          );
  }
  // Revert to default..
  $RESPONSE->select_database();
} 

// -----------------------------------------------------------------------
/**
* USER DEFINITIONS & SETUP
* Put any other setup calls on the $RESPONSE object, etc. here. Other
* sundry setup procedures that are required 'early' should also be
* included here.
*
* NOTE: If you have Microsite Features enabled (control panel), then the
* '$theme' variable will have possibly been set in response-defs.php
* above already. Be aware of this if you are intending to set the
* '$theme' variable yourself here.
*/

// -----------------------------------------------------------------------
?>