<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    context-defs.php                                        */
/* Author:      Paul Waite                                              */
/* Description: Definitions for managing Application Context.           */
/*              The context is basically just a collection of data      */
/*              which is maintained as a part of the session for this   */
/*              particular application. Customise as required.          */
/*              NOTE: this data might come from all sorts of sources    */
/*                    such as session rec, config rec etc.              */
/*                                                                      */
/* ******************************************************************** */
// Handle user sessions
class context {
  // Context variables. These are fetched in one hit with
  // the getvars() function. Define your own vars here as
  // required by your app..

  // Objects/records. In general these will be fetched
  // on demand only, for performance reasons..
  var $config;         // Pointer to configuration object

  function context() {
    // Initialise any extra context vars not grabbed by
    // getvars() here, if any.
    $this->getvars();
  } // context

  // Get the context variables. You provide the code here to
  // go out and get the context vars you defined above..
  function getvars() {
    global $RESPONSE;
    if ($RESPONSE->session_id) {
      // Acquire and/or assign your vars defined above here.
      // Usually this mean writing database access statements.

      // Execute DB statements and populate class vars here..

      return true;
    }
    else return false;
  } // getvars

  // Update session vars to database and session. You write the
  // code to save your variables to the database here..
  function putvars() {
    global $RESPONSE;
    $res = false;
    if ($RESPONSE->session_id) {
      // Write code in here to save your context variables
      // if required. We don't save everything we read..

      // Execute DB statements to save class vars here..
    }
    return $res;
  } // putvars

  // Get the system config record..
  function getconfig() {
    $this->config = new configuration("sys_control");
    return $this;
  } // getconfig

  // This function is an expose of the function value()
  // in the configuration object. For convenience..
  function configvalue($fieldname) {
    if (!isset($this->config)) {
      $this->getconfig();
    }
    return $this->config->value($fieldname);
  } // configvalue

  function putconfig() {
    return $this->config->put();
  } // putconfig

} // context class

// ----------------------------------------------------------------------
?>