<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-clock.php                                          */
/* Author:      Paul Waite                                              */
/* Description: An example of how the clock class might be used.        */
/*              The class is designed such that multiple of them can    */
/*              co-exist in the same webapge, with different styles     */
/*              times and timeszone settings.                           */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("clock-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Clock", "main", $theme);

// -----------------------------------------------------------------------
// Common site-specific content..
include_once("site-webpage.php");

// Local time and date
$clock = new digital_clock();
$clock->settitle("Local Time");
$clock->setstyle("width:80px;text-align:center;border:1px solid grey;background-color:#F0EEDC;");
$clock->show_seconds();
$clock->show_24hrs();
$clock->set_css_time("font:bold 10pt arial,helvetica,sans-serif;padding:1px;");
$clock->set_css_date("font:normal 8pt arial,helvetica,sans-serif;");
$CLOCK_LOCAL = $clock->render();

// GMT
$clock = new digital_clock();
$clock->settitle("GMT");
$clock->setstyle("width:120px;text-align:center;border:1px solid #22EDFF;background-color:#82A3C0;");
$clock->show_date();
$clock->set_css_time("font:bold 10pt arial,helvetica,sans-serif;color:#C2FFD9");
$clock->set_css_date("font:bold italic 10pt arial,helvetica,sans-serif;color:#C2FFD9");
$clock->set_to_gmt();
$clock->show_date_first();
$clock->set_date_format("d/m/yy");
$clock->show_inline();
$clock->set_update_interval_secs(30);
$CLOCK_GMT = $clock->render();

// Time in Hong Kong
$clock = new digital_clock();
$clock->settitle("Time in Hong Kong");
$clock->setstyle("width:140px;text-align:center;border:1px solid #F0EEDC;background-color:black;");
$clock->show_date();
$clock->show_dayname();
$clock->abbreviate_dayname();
$clock->set_css_time("font:bold 10pt arial,helvetica,sans-serif;padding:3px;color:#F0EEDC;padding-bottom:3px;");
$clock->set_css_date("font:bold 10pt arial,helvetica,sans-serif;color:#F0EEDC;padding-top:3px;");
$clock->set_timezone(+8);
$clock->show_date_first();
$clock->set_update_interval_secs(30);
$CLOCK_HONGKONG = $clock->render();

// Time in New York
$clock = new digital_clock();
$clock->settitle("New York Time");
$clock->setstyle("width:160px;text-align:center;border:1px solid #F5DD64;background-color:#65843D;");
$clock->show_seconds();
$clock->show_date();
$clock->show_dayname();
$clock->set_css_time("font:bold 14pt arial,helvetica,sans-serif;padding-top:5px;color:#FFE668;");
$clock->set_css_date("font:normal 10pt arial,helvetica,sans-serif;color:#FFE668;padding-bottom:5px;");
$clock->set_timezone(-4);
$CLOCK_NEWYORK = $clock->render();

// -----------------------------------------------------------------------------------------------
// MAIN CONTENT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<table border="0" cellspacing="0" cellpadding="6" width="85%" align="center" style="padding-top:20px">
  <tr class="axhdg">
    <th class="axhdg" colspan="2" style="text-align:center">Example Usage of Axyl Updating Clock</td>
  </tr>
  <tr>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td style="font-weight:bold;color:#F0EEDC;">Local Time 24-hour Clock</td>
    <td><!--CLOCK_LOCAL--></td>
  </tr>
  <tr>
    <td style="font-weight:bold;color:#F0EEDC">Time & Date at the Greenwich Meridian (GMT)</td>
    <td><!--CLOCK_GMT--></td>
  </tr>
  <tr>
    <td style="font-weight:bold;color:#F0EEDC">Time & Date In Hong Kong</td>
    <td><!--CLOCK_HONGKONG--></td>
  </tr>
  <tr>
    <td style="font-weight:bold;color:#F0EEDC">Time & Date In New York</td>
    <td><!--CLOCK_NEWYORK--></td>
  </tr>
</table>
<?php
$RESPONSE->plugin_inline();

// -----------------------------------------------------------------------
// Plugins..
$RESPONSE->plugin("CLOCK_LOCAL",    $CLOCK_LOCAL);
$RESPONSE->plugin("CLOCK_GMT",      $CLOCK_GMT);
$RESPONSE->plugin("CLOCK_NEWYORK",  $CLOCK_NEWYORK);
$RESPONSE->plugin("CLOCK_HONGKONG", $CLOCK_HONGKONG);

// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>