/***************************************************************************
 *   Copyright (C) 2006 by Bjorn Hansen                                    *
 *   holomorph@users.sourceforge.net                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../../include/menu/gamesetup.h"
#include "../../include/configmanager.h"
#include "../../include/menu/samplemapwidget.h"
#include "../../include/menu/maplistmodel.h"

using namespace Balder;

GameSetupMenu::GameSetupMenu(gcn::Container* top, SubMenu* parent):SubMenu(top,parent)
{
    page->setDimension(gcn::Rectangle(0,0,500,400));
    page->setPosition(150,200);

    backButton = new gcn::Button("Back");
    backButton->setEventId("back");
    backButton->addActionListener(this);

    sampleMap = new SampleMapWidget(ConfigManager::GetMap(), 0, 0, 100, 80);

    mapnameLabel = new gcn::Label("Map: ");
    maplistModel = new MapListModel();
    mapScrollArea = new gcn::ScrollArea();
    mapListBox = new gcn::ListBox();
    mapListBox->setWidth(400 - mapnameLabel->getWidth());
    mapListBox->setEventId("selectNewMap");
    mapListBox->addActionListener(this);
    mapDropDown = new gcn::DropDown(maplistModel, mapScrollArea, mapListBox);
    mapDropDown->setWidth(mapListBox->getWidth()+20);
    mapDropDown->setSelected(maplistModel->FindMapIndex(ConfigManager::GetMap()));

    int score = ConfigManager::GetIntValue("GameSetup", "ScoreLimit");
    int time = ConfigManager::GetIntValue("GameSetup", "TimeLimit");
    int life = ConfigManager::GetIntValue("GameSetup", "LifeLimit");
    scoreLimitSelector = new gcn::CheckBox("Maximum Score", score > 0);
    scoreLimitSelector->setEventId("toggleScoreLimit");
    scoreLimitSelector->addActionListener(this);
    timeLimitSelector = new gcn::CheckBox("Time (minutes)", time > 0);
    timeLimitSelector->setEventId("toggleTimeLimit");
    timeLimitSelector->addActionListener(this);
    lifeLimitSelector = new gcn::CheckBox("Limited Lives", life > 0);
    lifeLimitSelector->setEventId("toggleLifeLimit");
    lifeLimitSelector->addActionListener(this);
    scoreLimitValue = new NumberField(score);
    scoreLimitValue->setEnabled(score > 0);
    scoreLimitValue->setVisible(score > 0);
    timeLimitValue = new NumberField(time);
    timeLimitValue->setEnabled(time > 0);
    timeLimitValue->setVisible(time > 0);
    lifeLimitValue = new NumberField(life);
    lifeLimitValue->setEnabled(life > 0);
    lifeLimitValue->setVisible(life > 0);
    page->add(backButton, 0, 300);
    page->add(sampleMap, (page->getWidth() - sampleMap->getWidth()) / 2, 0);
    page->add(mapnameLabel, (page->getWidth() - (mapnameLabel->getWidth() + mapDropDown->getWidth())) / 2, sampleMap->getHeight() + 10);
    page->add(mapDropDown, ((page->getWidth() - (mapnameLabel->getWidth() + mapDropDown->getWidth())) / 2) + mapnameLabel->getWidth(), mapnameLabel->getY());
    page->add(scoreLimitSelector, 0, mapnameLabel->getY() + 60);
    page->add(scoreLimitValue, 400, mapnameLabel->getY() + 60);
    page->add(timeLimitSelector, 0, scoreLimitSelector->getY() + 40);
    page->add(timeLimitValue, 400, scoreLimitSelector->getY() + 40);
    page->add(lifeLimitSelector, 0, scoreLimitSelector->getY() + 80);
    page->add(lifeLimitValue, 400, scoreLimitSelector->getY() + 80);
}

GameSetupMenu::~GameSetupMenu()
{}

void GameSetupMenu::action(const std::string& action)
{
    if (action == "selectNewMap")
    {
        ConfigManager::SetMap(maplistModel->getElementAt(mapListBox->getSelected()).c_str());
        sampleMap->setSampleMap(ConfigManager::GetMap());
    }
    else if (action == "toggleScoreLimit")
    {
        int score = scoreLimitValue->getValue()*-1;
        if (0 == score) score = -10;
        scoreLimitSelector->setMarked (score > 0);
        scoreLimitValue->setValue(score);
        scoreLimitValue->setEnabled(score > 0);
        scoreLimitValue->setVisible(score > 0);
        ConfigManager::SetIntValue("GameSetup", "ScoreLimit", scoreLimitValue->getValue());
    }
    else if (action == "toggleTimeLimit")
    {
        int time = timeLimitValue->getValue()*-1;
        if (0 == time) time = 10;
        timeLimitSelector->setMarked (time > 0);
        timeLimitValue->setValue(time);
        timeLimitValue->setEnabled(time > 0);
        timeLimitValue->setVisible(time > 0);
        ConfigManager::SetIntValue("GameSetup", "TimeLimit", timeLimitValue->getValue());
    }
    else if (action == "toggleLifeLimit")
    {
        int life = lifeLimitValue->getValue()*-1;
        if (0 == life) life = -10;
        lifeLimitSelector->setMarked (life > 0);
        lifeLimitValue->setValue(life);
        lifeLimitValue->setEnabled(life > 0);
        lifeLimitValue->setVisible(life > 0);
        ConfigManager::SetIntValue("GameSetup", "LifeLimit", lifeLimitValue->getValue());
    }
    else if (action == "back")
    {
        hide();
        parent->show();
    }
}
