//  wminterface.cc for bbtools.
//
//  Copyright (c) 1998-1999 by John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#include "wminterface.hh"
#include "resource.hh"
#include "BaseDisplay.hh"

WMInterface::WMInterface(ToolWindow *toolwindow) : NETInterface(toolwindow) {
  bbtool=toolwindow;
}

WMInterface::~WMInterface() {}

void WMInterface::moduleInit() {
}

void WMInterface::sendClientMessage(Atom atom, XID data) {
  XEvent e;
  unsigned long mask;

  e.xclient.type = ClientMessage;
  e.xclient.window =  bbtool->getCurrentScreenInfo()->getRootWindow();
//bbtool->framewin;

  e.xclient.message_type = atom;
  e.xclient.format = 32;
  e.xclient.data.l[0] = (unsigned long) data;
  e.xclient.data.l[1] = 0;

  mask =  SubstructureRedirectMask;
  XSendEvent(bbtool->getXDisplay(), 
             bbtool->getCurrentScreenInfo()->getRootWindow(),
             False, mask, &e);
}

void WMInterface::changeDesktop(int desk_number) {
  unsigned long int data=desk_number;

  sendClientMessage(bbtool->getBlackboxChangeWorkspaceAtom(),data);
}


void WMInterface::sendWindowToDesktop(Window win,int desk_number) {
  XEvent e;
  unsigned long mask;

  e.xclient.type = ClientMessage;
  e.xclient.window = win;
  e.xclient.message_type = bbtool->getBlackboxChangeAttributesAtom();
  e.xclient.format = 32;
  e.xclient.data.l[0] = AttribWorkspace;
  e.xclient.data.l[1] = 0;
  e.xclient.data.l[2] = desk_number;
  e.xclient.data.l[3] = 0; 
  e.xclient.data.l[4] = 0;
  e.xclient.data.l[5] = 0;

  mask =  SubstructureRedirectMask;
  XSendEvent(bbtool->getXDisplay(), 
             bbtool->getCurrentScreenInfo()->getRootWindow(),
             False, mask, &e);

}

void WMInterface::setWindowFocus(Window win) {
  XEvent e;
  unsigned long mask;

  e.xclient.type = ClientMessage;
  e.xclient.window =  win;

  e.xclient.message_type = bbtool->getBlackboxChangeWindowFocusAtom();
  e.xclient.format = 32;
  e.xclient.data.l[0] = 0;
  e.xclient.data.l[1] = 0;

  mask =  SubstructureRedirectMask;
  XSendEvent(bbtool->getXDisplay(), 
             bbtool->getCurrentScreenInfo()->getRootWindow(),
             False, mask, &e);
}

void WMInterface::setWindowShade(Window win,bool shade) {
  XEvent e;
  unsigned long mask;

  e.xclient.type = ClientMessage;
  e.xclient.window = win;
  e.xclient.message_type = bbtool->getBlackboxChangeAttributesAtom();
  e.xclient.format = 32;
  e.xclient.data.l[0] = AttribShaded;
  if (shade) e.xclient.data.l[1] = AttribShaded;
  else e.xclient.data.l[1] = 0;
  e.xclient.data.l[2] = 0;
  e.xclient.data.l[3] = 0; 
  e.xclient.data.l[4] = 0;
  e.xclient.data.l[5] = 0;

  mask =  SubstructureRedirectMask;
  XSendEvent(bbtool->getXDisplay(), 
             bbtool->getCurrentScreenInfo()->getRootWindow(),
             False, mask, &e);
}

void WMInterface::setIconicState(Window win,bool iconize) {
 XEvent e;
  unsigned long mask;

    e.xclient.type = ClientMessage;
    e.xclient.window = win;
    e.xclient.message_type = bbtool->getWMChangeStateAtom();
    e.xclient.format = 32;
    if (iconize) e.xclient.data.l[0] = IconicState;
    else e.xclient.data.l[0] = NormalState;
    e.xclient.data.l[1] = 0;
    mask =  SubstructureRedirectMask;
    XSendEvent(bbtool->getXDisplay(), 
               bbtool->getCurrentScreenInfo()->getRootWindow(),
               False, mask, &e);
}


int WMInterface::isIconicState(Window win) {
  Atom real_type;
  int format;
  unsigned long n, extra;
  int status;
  long *p=0;

  status = XGetWindowProperty(bbtool->getXDisplay(), win, 
                              bbtool->getWMStateAtom(), 0L, 1L,
                              False, bbtool->getWMStateAtom(), &real_type,
                              &format, &n, &extra,  (unsigned char**)&p);
  if (!status) {
    if (p) return (p[0]==IconicState) ? 1 : 0;
    else return 0;
  }

  return -1;
}

int WMInterface::getAttributes(Window win) {
  Atom real_type;
  int format;
  unsigned long n, extra;
  int status;
  long *p=0;

  
  status = XGetWindowProperty(bbtool->getXDisplay(), win, 
                              bbtool->getBlackboxAttributesAtom(), 0L, 1L,
                              False, bbtool->getBlackboxAttributesAtom(), 
                              &real_type, &format,&n, &extra,  
                              (unsigned char**)&p);
  if (!status) {
    if (p) return p[0];
    else return 0;
  }

  return -1;
}


void WMInterface::addSticky(WindowList *tmp)
{
}

void WMInterface::removeSticky(Window win,int keep_on_desktop)
{
}

void WMInterface::changeIconState(Window win) {
/*  int status;
  LinkedListIterator<WindowList> win_it(bbtool->windowList);
  for (; win_it.current(); win_it++)
    if ((win_it.current()->win) == win)
      break;

  if (win_it.current()) {
    WindowList *tmp = win_it.current();
    
    status=isIconicState(tmp->win);

    if (status==-1) return;
    if (status&BLACKBOXAttribOmnipresent) {
      if (!tmp->sticky) {
        XUnmapWindow(bbtool->getXDisplay(),tmp->pager_win);
        tmp->icon=True;
      }
      else {
        LinkedListIterator<WindowList> win_it(bbtool->windowList);
        for (; win_it.current(); win_it++) {
          if (win_it.current()->win==tmp->win) {
            XUnmapWindow(bbtool->getXDisplay(),win_it.current()->pager_win);
            win_it.current()->icon=True;
          }
        }
      }
    }
    else 
      if (tmp->icon) {
        if (!tmp->sticky) {
          XMapWindow(bbtool->getXDisplay(),tmp->pager_win);
          tmp->icon=False;
        }
        else {
          LinkedListIterator<WindowList> win_it(bbtool->windowList);
  
          for (; win_it.current(); win_it++) {
            if (win_it.current()->win==tmp->win) {
              XMapWindow(bbtool->getXDisplay(),win_it.current()->pager_win);
              win_it.current()->icon=False;
            }
          }
        }
      }
    }*/
}


void WMInterface::windowAttributeChange(Window win) {
/*  Atom real_type;
  int format;
  unsigned long n, extra;
  AppWindow *tmp=0;
  BlackboxHints *net_hint;

  {
    LinkedListIterator<AppWindow> win_it(bbtool->appWindowList);
    for (; win_it.current(); win_it++)
      if ((win_it.current()->getWindow()) == win) {
        tmp = win_it.current();
    }
  }
  if (tmp) {

    if (XGetWindowProperty(bbtool->getXDisplay(), win, 
                          bbtool->getBlackboxAttributesAtom(), 0L, 
                          PropBlackboxHintsElements, False, 
                          bbtool->getBlackboxAttributesAtom(), 
                          &real_type, &format,&n, &extra,  
                          (unsigned char**)&net_hint) == Success && net_hint) {

  
      if (n == PropBlackboxHintsElements) {
        if (net_hint->flags & AttribShaded)
          tmp->setShaded(net_hint->attrib & AttribShaded);

        if (net_hint->flags & AttribOmnipresent)
          tmp->setOmniPresent(net_hint->attrib & AttribOmnipresent);

        if (net_hint->flags & AttribWorkspace)
          tmp->setDesktopNr(net_hint->workspace);

        if (net_hint->flags & AttribDecoration) {
          tmp->setDecoration(net_hint->decoration);
          fprintf(stderr,"%ul\n",net_hint->decoration);
        }
       if (isIconicState(win)) 
          tmp->setIconized(true);
        else
          tmp->setIconized(false);
      }
    }
  }*/
}

void WMInterface::NETNotifyStartup() {
  bbtool->setNETInit(); //wm_init=True;
/*  XClearWindow(bbtool->getXDisplay(), bbtool->framewin);
  XMapWindow(bbtool->getXDisplay(), bbtool->framewin);
  XMapSubwindows(bbtool->getXDisplay(), bbtool->framewin);*/
}

void WMInterface::NETNotifyWindowAdd(Window win,int desktop_nr) {

  bbtool->addAppWindow(&win,False);
/*  AppWindow *tmp = new AppWindow(bbtool,win);


  tmp->setWindow(win);
  int status=bbtool->getWindowGeometry(tmp);
  if (status) {
    if (isIconicState(tmp->getWindow())) tmp->setIconized(True);
    else tmp->setIconized(False);
    tmp->setOmniPresent(False);
    tmp->setFocused(False);
    tmp->setShaded(False);
    tmp->setDesktopNr(desktop_nr);

    if (tmp->getDesktopNr()>=0) {
      fprintf(stderr,"add window \n\n\n");
      bbtool->appWindowList->insert(tmp);
      if (getAttributes(tmp->getWindow())&AttribOmnipresent) 
        tmp->setOmniPresent(True);
    }
    else delete tmp;
  } else delete tmp;*/
}

void WMInterface::setDecor(Window win,bool decor) {
  XEvent e;
  unsigned long mask;

  e.xclient.type = ClientMessage;
  e.xclient.window = win;
  e.xclient.message_type = bbtool->getBlackboxChangeAttributesAtom();
  e.xclient.format = 32;
  e.xclient.data.l[0] = AttribDecoration;
  e.xclient.data.l[1] = 0;
  e.xclient.data.l[2] = 0;
  e.xclient.data.l[3] = 0; 
  if (decor) {
    e.xclient.data.l[4] = DecorNormal;
  }
  else { 
    e.xclient.data.l[4] = DecorNone;
  }
  e.xclient.data.l[5] = 0;

  mask =  SubstructureRedirectMask;
  XSendEvent(bbtool->getXDisplay(),
                  bbtool->getCurrentScreenInfo()->getRootWindow(),
                 False, mask, &e);
}

void WMInterface::setOmniPresent(Window win,bool omnipresent) {
  XEvent e;
  unsigned long mask;

  e.xclient.type = ClientMessage;
  e.xclient.window = win;
  e.xclient.message_type = bbtool->getBlackboxChangeAttributesAtom();
  e.xclient.format = 32;
  e.xclient.data.l[0] = AttribOmnipresent;
  if (omnipresent) e.xclient.data.l[1] = AttribOmnipresent;
  else e.xclient.data.l[1] = 0;
  e.xclient.data.l[2] = 0;
  e.xclient.data.l[3] = 0; 
  e.xclient.data.l[4] = 0;
  e.xclient.data.l[5] = 0;

  mask =  SubstructureRedirectMask;
  XSendEvent(bbtool->getXDisplay(), 
             bbtool->getCurrentScreenInfo()->getRootWindow(),
             False, mask, &e);

}

void WMInterface::NETNotifyDel(Window win) {
  bbtool->removeAppWindow(win);
}

void WMInterface::NETNotifyAttributes(Window win) {
  windowAttributeChange(win);
}

void WMInterface::NETNotifyFocus(Window win) {
//  if (bbtool->getResource()->getFocusStyle()!=none)
//   bbtool->focusWindow(win);
}

void WMInterface::NETNotifyCurrentWorkspace(int current_desktop) {
//  bbtool->desktopChange(current_desktop);
//      bbtool->redraw=True;
}

void WMInterface::NETNotifyWorkspaceCount(int number_of_desktops) {
/*  int old_number_of_desktops = bbtool->getNumberOfDesktops();
  bbtool->setNumberOfDesktops(number_of_desktops);
  if (number_of_desktops>old_number_of_desktops) {
  int i;
  for (i=old_number_of_desktops;i<number_of_desktops;i++) {
    DesktopList *tmp = new DesktopList;
    bbtool->addDesktopWindow(tmp,False);
    bbtool->desktopList->insert(tmp);
    LinkedListIterator<WindowList> win_it(bbtool->windowList);
    for (; win_it.current(); win_it++)
      if ((win_it.current()->sticky &&win_it.current()->desktop_nr==1))
      break;
      if (win_it.current()) {
        WindowList *sticky= win_it.current();
        WindowList *copy = new WindowList;
        copy->win= sticky->win;
        copy->width=sticky->width;
        copy->height=sticky->height;
        copy->x_position=sticky->x_position;
        copy->y_position=sticky->y_position;
        copy->icon=sticky->icon;
        copy->sticky=sticky->sticky;
        copy->shaded=sticky->shaded;
        copy->desktop_nr=tmp->desktop_nr;
        bbtool->addFrameWindow(copy,0,False);
        bbtool->windowList->insert(copy);
      }
    }
  } else if (number_of_desktops<old_number_of_desktops)
    bbtool->removeDesktopWindow();*/
}

void WMInterface::moveWindow(Window win, int x, int y) {
	XMoveWindow(bbtool->getXDisplay(), win, x, y);
}

void WMInterface::resizeWindow(Window win, int width, int height) {
	XResizeWindow(bbtool->getXDisplay(), win, width, height);
}

