
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsepart.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsepart.h>
#include        <bse/bsesong.h>


#line 26 "bsepart.proc"


/* --- insert-note-auto --- */
static void
insert_note_auto_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsepart.proc"
 {
#line 30 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 45 "bsepart.proc"
 }
static BseErrorType
#line 45 "bsepart.proc"
insert_note_auto_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 48 "bsepart.proc"
{
#line 49 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
  
#line 59 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 63 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-note-auto");
  id = bse_part_insert_note (self, ~0, tick, duration, note, fine_tune, velocity);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);

#line 70 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- insert-note --- */
static void
insert_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 76 "bsepart.proc"
 {
#line 78 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("channel", "Channel", NULL,
			 0, 0, BSE_PART_MAX_CHANNELS, 4, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 95 "bsepart.proc"
 }
static BseErrorType
#line 95 "bsepart.proc"
insert_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 98 "bsepart.proc"
{
#line 99 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    channel   = sfi_value_get_int (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
  
#line 110 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 114 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-note");
  id = bse_part_insert_note (self, channel, tick, duration, note, fine_tune, velocity);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);

#line 121 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- insert-control --- */
static void
insert_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 127 "bsepart.proc"
 {
#line 129 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("value", "Value", NULL,
			  0.0, -1.0, +1.0, 0.1,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 142 "bsepart.proc"
 }
static BseErrorType
#line 142 "bsepart.proc"
insert_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 145 "bsepart.proc"
{
#line 146 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    ctype     = g_value_get_enum (in_values++);
  gfloat   value     = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
  
#line 154 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 158 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-event");
  id = bse_part_insert_control (self, tick, ctype, value);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);

#line 165 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- change-note --- */
static void
change_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 171 "bsepart.proc"
 {
#line 173 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 191 "bsepart.proc"
 }
static BseErrorType
#line 191 "bsepart.proc"
change_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 194 "bsepart.proc"
{
#line 195 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    id	     = sfi_value_get_int (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  gboolean success = FALSE;
  BsePartQueryEvent equery;

#line 206 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 210 "bsepart.proc"
  
  if (bse_part_query_event (self, id, &equery) == BSE_PART_EVENT_NOTE)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-note");
      if (equery.tick != tick || equery.duration != duration ||
          equery.note != note || equery.fine_tune != fine_tune ||
          equery.velocity != velocity)
        {
          success = bse_part_change_note (self, id, ~0, tick, duration, note, fine_tune, velocity);
          if (success)
            bse_item_push_undo_proc (self, "change-note", id, equery.tick, equery.duration,
                                     equery.note, equery.fine_tune, equery.velocity);
        }
      else
        success = TRUE;
      bse_item_undo_close (ustack);
    }

#line 228 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- change-control --- */
static void
change_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 234 "bsepart.proc"
 {
#line 236 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("value", "Value", NULL,
			  0.0, -1.0, +1.0, 0.1,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 252 "bsepart.proc"
 }
static BseErrorType
#line 252 "bsepart.proc"
change_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 255 "bsepart.proc"
{
#line 256 "bsepart.proc"
  
  BsePart *self  = bse_value_get_object (in_values++);
  guint    id    = sfi_value_get_int (in_values++);
  guint    tick  = sfi_value_get_int (in_values++);
  guint    ctype = g_value_get_enum (in_values++);
  gfloat   value = sfi_value_get_real (in_values++);
  BsePartQueryEvent equery;
  gboolean success = FALSE;

#line 265 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 269 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL && !BSE_PART_NOTE_CONTROL (ctype))
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-control");
      if (equery.tick != tick || equery.control_type != ctype || equery.control_value != value)
        {
          success = bse_part_change_control (self, id, tick, ctype, value);
          if (success)
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, equery.control_type, equery.control_value);
        }
      else
        success = TRUE;
      bse_item_undo_close (ustack);
    }
  else if (equery.event_type == BSE_PART_EVENT_NOTE && BSE_PART_NOTE_CONTROL (ctype))
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-control");
      BsePartQueryEvent xquery;
      success = bse_part_change_control (self, id, tick, ctype, value);
      if (success && bse_part_query_event (self, id, &xquery) == BSE_PART_EVENT_NOTE &&
          (equery.fine_tune_value != xquery.fine_tune_value ||
           equery.velocity_value  != xquery.velocity_value))
        switch (ctype)
          {
          case BSE_MIDI_SIGNAL_VELOCITY:
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, ctype, equery.velocity_value);
            break;
          case BSE_MIDI_SIGNAL_FINE_TUNE:
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, ctype, equery.fine_tune_value);
            break;
          default: ;
          }
      bse_item_undo_close (ustack);
    }
  
#line 305 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- delete-event --- */
static void
delete_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 311 "bsepart.proc"
 {
#line 313 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 321 "bsepart.proc"
 }
static BseErrorType
#line 321 "bsepart.proc"
delete_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 324 "bsepart.proc"
{
#line 325 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
  gboolean deleted = FALSE;

#line 331 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 335 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_NOTE)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "delete-note");
      deleted = bse_part_delete_note (self, id, equery.channel);
      if (deleted)
        bse_item_push_undo_proc (self, "insert-note", equery.channel, equery.tick, equery.duration,
                                 equery.note, equery.fine_tune, equery.velocity);
      bse_item_undo_close (ustack);
    }
  else if (equery.event_type == BSE_PART_EVENT_CONTROL)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "delete-control");
      deleted = bse_part_delete_control (self, id);
      if (deleted)
        bse_item_push_undo_proc (self, "insert-control", equery.tick, equery.control_type, equery.control_value);
      bse_item_undo_close (ustack);
    }

#line 355 "bsepart.proc"
  
  g_value_set_enum (out_values++, deleted ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- is-event-selected --- */
static void
is_event_selected_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 361 "bsepart.proc"
 {
#line 363 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("selected", "Selected", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 370 "bsepart.proc"
 }
static BseErrorType
#line 370 "bsepart.proc"
is_event_selected_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 373 "bsepart.proc"
{
#line 374 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean selected = FALSE;
  BsePartQueryEvent equery;

#line 380 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 384 "bsepart.proc"
  
  if (bse_part_query_event (self, id, &equery) != BSE_PART_EVENT_NONE)
    selected = equery.selected;

#line 388 "bsepart.proc"
  
  sfi_value_set_bool (out_values++, selected);
  
  return BSE_ERROR_NONE;
}

/* --- list-notes-crossing --- */
static void
list_notes_crossing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 394 "bsepart.proc"
 {
#line 396 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 405 "bsepart.proc"
 }
static BseErrorType
#line 405 "bsepart.proc"
list_notes_crossing_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 408 "bsepart.proc"
{
#line 409 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  
#line 414 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 418 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes (self, ~0, tick, duration, BSE_MIN_NOTE, BSE_MAX_NOTE, TRUE));
  
  return BSE_ERROR_NONE;
}

/* --- list-notes-within --- */
static void
list_notes_within_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 424 "bsepart.proc"
 {
#line 426 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("channel", "Channel", NULL,
			 0, 0, BSE_PART_MAX_CHANNELS, 4, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 437 "bsepart.proc"
 }
static BseErrorType
#line 437 "bsepart.proc"
list_notes_within_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 440 "bsepart.proc"
{
#line 441 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    channel  = sfi_value_get_int (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  
#line 447 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 451 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes (self, channel, tick, duration, BSE_MIN_NOTE, BSE_MAX_NOTE, FALSE));
  
  return BSE_ERROR_NONE;
}

/* --- list-controls --- */
static void
list_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 457 "bsepart.proc"
 {
#line 459 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 471 "bsepart.proc"
 }
static BseErrorType
#line 471 "bsepart.proc"
list_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 474 "bsepart.proc"
{
#line 475 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  guint    ctype     = g_value_get_enum (in_values++);
  
#line 481 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 485 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, ~0, tick, duration, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- queue-notes --- */
static void
queue_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 491 "bsepart.proc"
 {
#line 493 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 504 "bsepart.proc"
 }
static BseErrorType
#line 504 "bsepart.proc"
queue_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 507 "bsepart.proc"
{
#line 508 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     min_note = sfi_value_get_note (in_values++);
  gint     max_note = sfi_value_get_note (in_values++);
  
#line 515 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 519 "bsepart.proc"
  
  bse_part_queue_notes_within (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- queue-controls --- */
static void
queue_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 525 "bsepart.proc"
 {
#line 527 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
}
#line 534 "bsepart.proc"
 }
static BseErrorType
#line 534 "bsepart.proc"
queue_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 537 "bsepart.proc"
{
#line 538 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  
#line 543 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 547 "bsepart.proc"
  
  bse_part_queue_controls (self, tick, duration);
  
  return BSE_ERROR_NONE;
}

/* --- list-selected-notes --- */
static void
list_selected_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 553 "bsepart.proc"
 {
#line 555 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 560 "bsepart.proc"
 }
static BseErrorType
#line 560 "bsepart.proc"
list_selected_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 563 "bsepart.proc"
{
#line 564 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 567 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 571 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_selected_notes (self));
  
  return BSE_ERROR_NONE;
}

/* --- list-selected-controls --- */
static void
list_selected_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 577 "bsepart.proc"
 {
#line 579 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 587 "bsepart.proc"
 }
static BseErrorType
#line 587 "bsepart.proc"
list_selected_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 590 "bsepart.proc"
{
#line 591 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
  
#line 595 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 599 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_selected_controls (self, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- check-overlap --- */
static void
check_overlap_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 605 "bsepart.proc"
 {
#line 607 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 617 "bsepart.proc"
 }
static BseErrorType
#line 617 "bsepart.proc"
check_overlap_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 620 "bsepart.proc"
{
#line 621 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
  
#line 627 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 631 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes (self, ~0, tick, duration, note, note, TRUE));
  
  return BSE_ERROR_NONE;
}

/* --- get-notes --- */
static void
get_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 637 "bsepart.proc"
 {
#line 639 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 648 "bsepart.proc"
 }
static BseErrorType
#line 648 "bsepart.proc"
get_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 651 "bsepart.proc"
{
#line 652 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
  
#line 657 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 661 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes (self, ~0, tick, 1, note, note, TRUE));
  
  return BSE_ERROR_NONE;
}

/* --- get-controls --- */
static void
get_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 667 "bsepart.proc"
 {
#line 669 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 679 "bsepart.proc"
 }
static BseErrorType
#line 679 "bsepart.proc"
get_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 682 "bsepart.proc"
{
#line 683 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
  
#line 688 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 692 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, ~0, tick, 1, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- get-channel-controls --- */
static void
get_channel_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 698 "bsepart.proc"
 {
#line 700 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("channel", "Channel", NULL,
			 0, 0, BSE_PART_MAX_CHANNELS, 4, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
                         1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 714 "bsepart.proc"
 }
static BseErrorType
#line 714 "bsepart.proc"
get_channel_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 717 "bsepart.proc"
{
#line 718 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    channel  = sfi_value_get_int (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
  
#line 725 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 729 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, channel, tick, duration, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- get-min-note --- */
static void
get_min_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 735 "bsepart.proc"
 {
#line 737 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 742 "bsepart.proc"
 }
static BseErrorType
#line 742 "bsepart.proc"
get_min_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 745 "bsepart.proc"
{
#line 746 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 749 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 753 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MIN_NOTE);
  
  return BSE_ERROR_NONE;
}

/* --- get-max-note --- */
static void
get_max_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 759 "bsepart.proc"
 {
#line 761 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 766 "bsepart.proc"
 }
static BseErrorType
#line 766 "bsepart.proc"
get_max_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 769 "bsepart.proc"
{
#line 770 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 773 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 777 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MAX_NOTE);
  
  return BSE_ERROR_NONE;
}

/* --- select-notes-exclusive --- */
static void
select_notes_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 783 "bsepart.proc"
 {
#line 785 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 796 "bsepart.proc"
 }
static BseErrorType
#line 796 "bsepart.proc"
select_notes_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 799 "bsepart.proc"
{
#line 800 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 807 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_notes_exclusive (self, ~0, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- select-controls-exclusive --- */
static void
select_controls_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 816 "bsepart.proc"
 {
#line 818 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
}
#line 828 "bsepart.proc"
 }
static BseErrorType
#line 828 "bsepart.proc"
select_controls_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 831 "bsepart.proc"
{
#line 832 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
  
#line 838 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_controls_exclusive (self, tick, duration, ctype);
  
  return BSE_ERROR_NONE;
}

/* --- select-controls --- */
static void
select_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 847 "bsepart.proc"
 {
#line 849 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
}
#line 859 "bsepart.proc"
 }
static BseErrorType
#line 859 "bsepart.proc"
select_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 862 "bsepart.proc"
{
#line 863 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
  
#line 869 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_controls (self, tick, duration, ctype, TRUE);
  
  return BSE_ERROR_NONE;
}

/* --- select-notes --- */
static void
select_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 878 "bsepart.proc"
 {
#line 880 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 891 "bsepart.proc"
 }
static BseErrorType
#line 891 "bsepart.proc"
select_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 894 "bsepart.proc"
{
#line 895 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 902 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_notes (self, ~0, tick, duration, min_note, max_note, TRUE);
  
  return BSE_ERROR_NONE;
}

/* --- deselect-notes --- */
static void
deselect_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 911 "bsepart.proc"
 {
#line 913 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 924 "bsepart.proc"
 }
static BseErrorType
#line 924 "bsepart.proc"
deselect_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 927 "bsepart.proc"
{
#line 928 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 935 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_notes (self, ~0, tick, duration, min_note, max_note, FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- deselect-controls --- */
static void
deselect_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 944 "bsepart.proc"
 {
#line 946 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
}
#line 956 "bsepart.proc"
 }
static BseErrorType
#line 956 "bsepart.proc"
deselect_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 959 "bsepart.proc"
{
#line 960 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
  
#line 966 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_controls (self, tick, duration, ctype, FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- select-event --- */
static void
select_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 975 "bsepart.proc"
 {
#line 977 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 982 "bsepart.proc"
 }
static BseErrorType
#line 982 "bsepart.proc"
select_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 985 "bsepart.proc"
{
#line 986 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
  
#line 991 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 995 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL)
    bse_part_set_control_selected (self, id, TRUE);
  else if (equery.event_type == BSE_PART_EVENT_NOTE)
    bse_part_set_note_selected (self, id, equery.channel, TRUE);
  else
    return BSE_ERROR_PROC_PARAM_INVAL;
  return BSE_ERROR_NONE;
}

/* --- deselect-event --- */
static void
deselect_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 1006 "bsepart.proc"
 {
#line 1008 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 1013 "bsepart.proc"
 }
static BseErrorType
#line 1013 "bsepart.proc"
deselect_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 1016 "bsepart.proc"
{
#line 1017 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
  
#line 1022 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 1026 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL)
    bse_part_set_control_selected (self, id, FALSE);
  else if (equery.event_type == BSE_PART_EVENT_NOTE)
    bse_part_set_note_selected (self, id, equery.channel, FALSE);
  else
    return BSE_ERROR_PROC_PARAM_INVAL;
  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 1037 "bsepart.proc"
 {
#line 1039 "bsepart.proc"
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL, BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 1042 "bsepart.proc"
}  }
static BseErrorType
#line 1042 "bsepart.proc"
get_timing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 1045 "bsepart.proc"
{
#line 1046 "bsepart.proc"
  
  BsePart *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseItem *parent;
  BseSongTiming timing = { 0, };

#line 1052 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 1056 "bsepart.proc"
  
  parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent))
    bse_song_get_timing (BSE_SONG (parent), tick, &timing);
  else
    bse_song_timing_get_default (&timing);

#line 1063 "bsepart.proc"
  
  bse_value_set_boxed (out_values++, &timing);

  return BSE_ERROR_NONE;
}

/* --- list-links --- */
static void
list_links_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 1069 "bsepart.proc"
 {
#line 1071 "bsepart.proc"
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL, BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("link_list", "Link List", NULL,
                                BSE_TYPE_PART_LINK_SEQ, SFI_PARAM_STANDARD);
}
#line 1075 "bsepart.proc"
 }
static BseErrorType
#line 1075 "bsepart.proc"
list_links_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 1078 "bsepart.proc"
{
#line 1079 "bsepart.proc"
  
  BsePart *self = bse_value_get_object (in_values++);

#line 1082 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 1086 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_links (self));

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_insert_note_auto__fill_strings (BseExportStrings *es)
{
  es->blurb = "Insert a new note into a part with automatic channel selection.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 29;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_insert_note_auto = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BsePart+insert-note-auto", 
    NULL,
    "/Methods/BsePart/General/Insert Note Auto",
    NULL,
    __enode_insert_note_auto__fill_strings,
  },
  0, insert_note_auto_setup, insert_note_auto_exec, 
};
static void
__enode_insert_note__fill_strings (BseExportStrings *es)
{
  es->blurb = "Insert a new note into a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 77;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_insert_note = {
  { (BseExportNode*) &__enode_insert_note_auto, BSE_EXPORT_NODE_PROC,
    "BsePart+insert-note", 
    NULL,
    "/Methods/BsePart/General/Insert Note",
    NULL,
    __enode_insert_note__fill_strings,
  },
  0, insert_note_setup, insert_note_exec, 
};
static void
__enode_insert_control__fill_strings (BseExportStrings *es)
{
  es->blurb = "Insert a new control event into a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 128;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_insert_control = {
  { (BseExportNode*) &__enode_insert_note, BSE_EXPORT_NODE_PROC,
    "BsePart+insert-control", 
    NULL,
    "/Methods/BsePart/General/Insert Control",
    NULL,
    __enode_insert_control__fill_strings,
  },
  0, insert_control_setup, insert_control_exec, 
};
static void
__enode_change_note__fill_strings (BseExportStrings *es)
{
  es->blurb = "Change an existing note within a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 172;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_change_note = {
  { (BseExportNode*) &__enode_insert_control, BSE_EXPORT_NODE_PROC,
    "BsePart+change-note", 
    NULL,
    "/Methods/BsePart/General/Change Note",
    NULL,
    __enode_change_note__fill_strings,
  },
  0, change_note_setup, change_note_exec, 
};
static void
__enode_change_control__fill_strings (BseExportStrings *es)
{
  es->blurb = "Change an existing control event within a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 235;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_change_control = {
  { (BseExportNode*) &__enode_change_note, BSE_EXPORT_NODE_PROC,
    "BsePart+change-control", 
    NULL,
    "/Methods/BsePart/General/Change Control",
    NULL,
    __enode_change_control__fill_strings,
  },
  0, change_control_setup, change_control_exec, 
};
static void
__enode_delete_event__fill_strings (BseExportStrings *es)
{
  es->blurb = "Delete an existing event from a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 312;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_delete_event = {
  { (BseExportNode*) &__enode_change_control, BSE_EXPORT_NODE_PROC,
    "BsePart+delete-event", 
    NULL,
    "/Methods/BsePart/General/Delete Event",
    NULL,
    __enode_delete_event__fill_strings,
  },
  0, delete_event_setup, delete_event_exec, 
};
static void
__enode_is_event_selected__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether an event is selected.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 362;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_is_event_selected = {
  { (BseExportNode*) &__enode_delete_event, BSE_EXPORT_NODE_PROC,
    "BsePart+is-event-selected", 
    NULL,
    "/Methods/BsePart/General/Is Event Selected",
    NULL,
    __enode_is_event_selected__fill_strings,
  },
  0, is_event_selected_setup, is_event_selected_exec, 
};
static void
__enode_list_notes_crossing__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all notes within or crossing a tick range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 395;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_list_notes_crossing = {
  { (BseExportNode*) &__enode_is_event_selected, BSE_EXPORT_NODE_PROC,
    "BsePart+list-notes-crossing", 
    NULL,
    "/Methods/BsePart/General/List Notes Crossing",
    NULL,
    __enode_list_notes_crossing__fill_strings,
  },
  0, list_notes_crossing_setup, list_notes_crossing_exec, 
};
static void
__enode_list_notes_within__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all notes within a tick range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 425;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_list_notes_within = {
  { (BseExportNode*) &__enode_list_notes_crossing, BSE_EXPORT_NODE_PROC,
    "BsePart+list-notes-within", 
    NULL,
    "/Methods/BsePart/General/List Notes Within",
    NULL,
    __enode_list_notes_within__fill_strings,
  },
  0, list_notes_within_setup, list_notes_within_exec, 
};
static void
__enode_list_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all control events within a tick range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 458;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_list_controls = {
  { (BseExportNode*) &__enode_list_notes_within, BSE_EXPORT_NODE_PROC,
    "BsePart+list-controls", 
    NULL,
    "/Methods/BsePart/General/List Controls",
    NULL,
    __enode_list_controls__fill_strings,
  },
  0, list_controls_setup, list_controls_exec, 
};
static void
__enode_queue_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "Queue updates for all notes starting within the given rectangle.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 492;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_queue_notes = {
  { (BseExportNode*) &__enode_list_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+queue-notes", 
    NULL,
    "/Methods/BsePart/General/Queue Notes",
    NULL,
    __enode_queue_notes__fill_strings,
  },
  0, queue_notes_setup, queue_notes_exec, 
};
static void
__enode_queue_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Queue updates for all control events and notes starting within the given range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 526;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_queue_controls = {
  { (BseExportNode*) &__enode_queue_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+queue-controls", 
    NULL,
    "/Methods/BsePart/General/Queue Controls",
    NULL,
    __enode_queue_controls__fill_strings,
  },
  0, queue_controls_setup, queue_controls_exec, 
};
static void
__enode_list_selected_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all currently selected notes.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 554;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_list_selected_notes = {
  { (BseExportNode*) &__enode_queue_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+list-selected-notes", 
    NULL,
    "/Methods/BsePart/General/List Selected Notes",
    NULL,
    __enode_list_selected_notes__fill_strings,
  },
  0, list_selected_notes_setup, list_selected_notes_exec, 
};
static void
__enode_list_selected_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all currently selected control events of a specific type.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 578;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_list_selected_controls = {
  { (BseExportNode*) &__enode_list_selected_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+list-selected-controls", 
    NULL,
    "/Methods/BsePart/General/List Selected Controls",
    NULL,
    __enode_list_selected_controls__fill_strings,
  },
  0, list_selected_controls_setup, list_selected_controls_exec, 
};
static void
__enode_check_overlap__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a note would overlap with neighbours.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 606;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_check_overlap = {
  { (BseExportNode*) &__enode_list_selected_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+check-overlap", 
    NULL,
    "/Methods/BsePart/General/Check Overlap",
    NULL,
    __enode_check_overlap__fill_strings,
  },
  0, check_overlap_setup, check_overlap_exec, 
};
static void
__enode_get_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all notes of specific frequency at or crossing a specific tick.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 638;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_notes = {
  { (BseExportNode*) &__enode_check_overlap, BSE_EXPORT_NODE_PROC,
    "BsePart+get-notes", 
    NULL,
    "/Methods/BsePart/General/Get Notes",
    NULL,
    __enode_get_notes__fill_strings,
  },
  0, get_notes_setup, get_notes_exec, 
};
static void
__enode_get_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all control events of a specific type at specified tick.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 668;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_controls = {
  { (BseExportNode*) &__enode_get_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+get-controls", 
    NULL,
    "/Methods/BsePart/General/Get Controls",
    NULL,
    __enode_get_controls__fill_strings,
  },
  0, get_controls_setup, get_controls_exec, 
};
static void
__enode_get_channel_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all control events of a specific type within range of a channel.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 699;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_channel_controls = {
  { (BseExportNode*) &__enode_get_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+get-channel-controls", 
    NULL,
    "/Methods/BsePart/General/Get Channel Controls",
    NULL,
    __enode_get_channel_controls__fill_strings,
  },
  0, get_channel_controls_setup, get_channel_controls_exec, 
};
static void
__enode_get_min_note__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the minimum note supported in this part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 736;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_min_note = {
  { (BseExportNode*) &__enode_get_channel_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+get-min-note", 
    NULL,
    "/Methods/BsePart/General/Get Min Note",
    NULL,
    __enode_get_min_note__fill_strings,
  },
  0, get_min_note_setup, get_min_note_exec, 
};
static void
__enode_get_max_note__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the maximum note supported in this part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 760;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_max_note = {
  { (BseExportNode*) &__enode_get_min_note, BSE_EXPORT_NODE_PROC,
    "BsePart+get-max-note", 
    NULL,
    "/Methods/BsePart/General/Get Max Note",
    NULL,
    __enode_get_max_note__fill_strings,
  },
  0, get_max_note_setup, get_max_note_exec, 
};
static void
__enode_select_notes_exclusive__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select all notes within rectangle and deselect all others.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 784;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_select_notes_exclusive = {
  { (BseExportNode*) &__enode_get_max_note, BSE_EXPORT_NODE_PROC,
    "BsePart+select-notes-exclusive", 
    NULL,
    "/Methods/BsePart/General/Select Notes Exclusive",
    NULL,
    __enode_select_notes_exclusive__fill_strings,
  },
  0, select_notes_exclusive_setup, select_notes_exclusive_exec, 
};
static void
__enode_select_controls_exclusive__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select all control events within range and deselect all others.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 817;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_select_controls_exclusive = {
  { (BseExportNode*) &__enode_select_notes_exclusive, BSE_EXPORT_NODE_PROC,
    "BsePart+select-controls-exclusive", 
    NULL,
    "/Methods/BsePart/General/Select Controls Exclusive",
    NULL,
    __enode_select_controls_exclusive__fill_strings,
  },
  0, select_controls_exclusive_setup, select_controls_exclusive_exec, 
};
static void
__enode_select_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select all control events within range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 848;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_select_controls = {
  { (BseExportNode*) &__enode_select_controls_exclusive, BSE_EXPORT_NODE_PROC,
    "BsePart+select-controls", 
    NULL,
    "/Methods/BsePart/General/Select Controls",
    NULL,
    __enode_select_controls__fill_strings,
  },
  0, select_controls_setup, select_controls_exec, 
};
static void
__enode_select_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select all notes within rectangle.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 879;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_select_notes = {
  { (BseExportNode*) &__enode_select_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+select-notes", 
    NULL,
    "/Methods/BsePart/General/Select Notes",
    NULL,
    __enode_select_notes__fill_strings,
  },
  0, select_notes_setup, select_notes_exec, 
};
static void
__enode_deselect_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "Deselect all notes within rectangle.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 912;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_deselect_notes = {
  { (BseExportNode*) &__enode_select_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+deselect-notes", 
    NULL,
    "/Methods/BsePart/General/Deselect Notes",
    NULL,
    __enode_deselect_notes__fill_strings,
  },
  0, deselect_notes_setup, deselect_notes_exec, 
};
static void
__enode_deselect_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Deselect all controls within given range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 945;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_deselect_controls = {
  { (BseExportNode*) &__enode_deselect_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+deselect-controls", 
    NULL,
    "/Methods/BsePart/General/Deselect Controls",
    NULL,
    __enode_deselect_controls__fill_strings,
  },
  0, deselect_controls_setup, deselect_controls_exec, 
};
static void
__enode_select_event__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select an existing event.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 976;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_select_event = {
  { (BseExportNode*) &__enode_deselect_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+select-event", 
    NULL,
    "/Methods/BsePart/General/Select Event",
    NULL,
    __enode_select_event__fill_strings,
  },
  0, select_event_setup, select_event_exec, 
};
static void
__enode_deselect_event__fill_strings (BseExportStrings *es)
{
  es->blurb = "Deselect an existing event.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 1007;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_deselect_event = {
  { (BseExportNode*) &__enode_select_event, BSE_EXPORT_NODE_PROC,
    "BsePart+deselect-event", 
    NULL,
    "/Methods/BsePart/General/Deselect Event",
    NULL,
    __enode_deselect_event__fill_strings,
  },
  0, deselect_event_setup, deselect_event_exec, 
};
static void
__enode_get_timing__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve song timing information at a specific tick.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 1038;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_deselect_event, BSE_EXPORT_NODE_PROC,
    "BsePart+get-timing", 
    NULL,
    "/Methods/BsePart/General/Get Timing",
    NULL,
    __enode_get_timing__fill_strings,
  },
  0, get_timing_setup, get_timing_exec, 
};
static void
__enode_list_links__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all places where parts are used (linked) from tracks, sorted by tick.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 1070;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_list_links = {
  { (BseExportNode*) &__enode_get_timing, BSE_EXPORT_NODE_PROC,
    "BsePart+list-links", 
    NULL,
    "/Methods/BsePart/General/List Links",
    NULL,
    __enode_list_links__fill_strings,
  },
  0, list_links_setup, list_links_exec, 
};
BseExportNode* bse__builtin_init_bsepart_genprc_c (void);
BseExportNode* bse__builtin_init_bsepart_genprc_c (void)
{
  return (BseExportNode*) &__enode_list_links;
}

/*
 * Generated data ends here
 */
