/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HexEncoder.h"
#include <ostream>

char const HexEncoder::m_sHexChars[] = "0123456789abcdef";

std::string
HexEncoder::hexEncode(unsigned char const* const bytes, size_t const len)
{
	std::string hex;
	hex.reserve(len * 2);
	unsigned char const* p = bytes;
	unsigned char const* const end = p + len;
	for (; p != end; ++p) {
		hex += m_sHexChars[*p >> 4];
		hex += m_sHexChars[*p & 0x0f];
	}
	return hex;
}

void
HexEncoder::hexEncode(
	unsigned char const* const bytes, size_t const len, std::ostream& out)
{
	unsigned char const* p = bytes;
	unsigned char const* const end = p + len;
	for (; p != end; ++p) {
		out << m_sHexChars[*p >> 4];
		out << m_sHexChars[*p & 0x0f];
	}
}
