/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TAG_H_
#define TAG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusivePtr.h"

class TagProvideCompareOps;
class TagNoCompareOps;

/**
 * \brief Implementation detail of Tag.
 */
template<typename T>
class TagBase1
{
protected:
	explicit TagBase1(T* obj) : m_ptrObj(obj) {}
public:
	T& operator*() const { return *m_ptrObj; }
	
	T* operator->() const { return m_ptrObj.get(); }
	
	void swap(TagBase1& other) { m_ptrObj.swap(other.m_ptrObj); }
private:
	IntrusivePtr<T> m_ptrObj;
};


/**
 * \brief Implementation detail of Tag.
 */
template<typename T, typename Comp>
class TagBase2;


template<typename T>
class TagBase2<T, TagNoCompareOps> : public TagBase1<T>
{
protected:
	explicit TagBase2(T* obj) : TagBase1<T>(obj) {}
};


template<typename T>
class TagBase2<T, TagProvideCompareOps> : public TagBase1<T>
{
protected:
	explicit TagBase2(T* obj) : TagBase1<T>(obj) {}
public:
	bool operator==(TagBase2 const& rhs) const {
		return &**this == &*rhs;
	}
	
	bool operator!=(TagBase2 const& rhs) const {
		return &**this != &*rhs;
	}
	
	bool operator<(TagBase2 const& rhs) const {
		return &**this < &*rhs;
	}
	
	bool operator>(TagBase2 const& rhs) const {
		return &**this > &*rhs;
	}
	
	bool operator<=(TagBase2 const& rhs) const {
		return &**this <= &*rhs;
	}
	
	bool operator>=(TagBase2 const& rhs) const {
		return &**this >= &*rhs;
	}
};


/**
 * \brief A unique identifier optionally carrying additional data.
 */
template<typename T, typename Comp = TagProvideCompareOps>
class Tag : public TagBase2<T, Comp>
{
public:
	Tag() : TagBase2<T, Comp>(new T) {}
	
	// Member-wise copying is OK.
	
	template<typename OT, typename OComp>
	explicit Tag(Tag<OT, OComp> const& other)
	: TagBase2<T, Comp>(&*other) {}
protected:
	explicit Tag(T* obj) : TagBase2<T, Comp>(obj) {}
};


template<typename T, typename Comp>
inline void swap(Tag<T, Comp>& lhs, Tag<T, Comp>& rhs)
{
	lhs.swap(rhs);
}

#endif
