/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CHAINCONNECTORLISTENER_H_
#define CHAINCONNECTORLISTENER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Observer.h"
#include "AutoClosingSAP.h"
#include <ace/config-lite.h>
#include <ace/SOCK_Stream.h>

class AsyncConnectorError;
class SocksError;
class SymbolicInetAddr;
class ProxyDescriptor;

class ChainConnectorListener : public ObserverBase
{
public:
	virtual ~ChainConnectorListener() {}
	
	virtual void onConnectionEstablished(
		AutoClosingSAP<ACE_SOCK_Stream>& conn) = 0;
	
	/**
	 * \brief Handle a failed connection to \a addr.
	 */
	virtual void onConnectionFailed(
		AsyncConnectorError const& err,
		SymbolicInetAddr const& addr) = 0;
	
	/**
	 * \brief Handle a problem forwarding through \a proxy.
	 */
	virtual void onConnectionFailed(
		SocksError const& err,
		ProxyDescriptor const& proxy) = 0;
	
	/**
	 * \brief Handle a generic problem forwarding through \a proxy.
	 */
	virtual void onConnectionFailed(
		std::string const& error_message,
		ProxyDescriptor const& proxy) = 0;
};

#endif
