/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef COLOR_H_
#define COLOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"

class Color
{
public:
	Color(uint8_t r, uint8_t g, uint8_t b);
	
	bool operator==(Color const& other) const;
	
	bool operator!=(Color const& other) const;
	
	uint8_t getRed() const { return m_rgb[0]; }
	
	uint8_t getGreen() const { return m_rgb[1]; }
	
	uint8_t getBlue() const { return m_rgb[2]; }
	
	uint8_t const* getRGB() const { return m_rgb; }
private:
	uint8_t m_rgb[3];
};

#endif
