/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HtmlNodeWithoutAttributes.h"

BString const HtmlNodeWithoutAttributes::m_sEmptyString;
HtmlNode::AttributeMap const HtmlNodeWithoutAttributes::m_sEmptyAttributes;

BString const&
HtmlNodeWithoutAttributes::getTagName() const
{
	return m_sEmptyString;
}

void
HtmlNodeWithoutAttributes::setTagName(BString const& name)
{
}

int
HtmlNodeWithoutAttributes::getTagType() const
{
	return 0;
}

void
HtmlNodeWithoutAttributes::setTagType(int type)
{
}

bool
HtmlNodeWithoutAttributes::isClosed() const
{
	return false;
}

void
HtmlNodeWithoutAttributes::setClosed(bool closed)
{
}

bool
HtmlNodeWithoutAttributes::hasAdMark() const
{
	return false;
}

void
HtmlNodeWithoutAttributes::setAdMark(bool mark)
{
}

HtmlNode::AttributeMap const&
HtmlNodeWithoutAttributes::getRawAttributes() const
{
	return m_sEmptyAttributes;
}

bool
HtmlNodeWithoutAttributes::hasAttribute(BString const& name) const
{
	return false;
}

bool
HtmlNodeWithoutAttributes::isBooleanAttribute(BString const& name) const
{
	return false;
}

BString
HtmlNodeWithoutAttributes::getRawAttribute(BString const& name) const
{
	return m_sEmptyString;
}

BString
HtmlNodeWithoutAttributes::getAttribute(BString const& name) const
{
	return m_sEmptyString;
}

void
HtmlNodeWithoutAttributes::setRawAttribute(BString const& name, BString const& value)
{
}

void
HtmlNodeWithoutAttributes::setAttribute(BString const& name, BString const& value)
{
}

void
HtmlNodeWithoutAttributes::setBooleanAttribute(BString const& name)
{
}

void
HtmlNodeWithoutAttributes::removeAttribute(BString const& name)
{
}
