/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPHEADERSTRUCTURE_H_
#define HTTPHEADERSTRUCTURE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpHeaderElement.h"
#include <list>
#include <iosfwd>

class BString;
class HttpHeader;

class HttpHeaderStructure
{
public:
	HttpHeaderStructure() {}
	
	HttpHeaderStructure(HttpHeader const& header);
	
	bool empty() const { return m_elements.empty(); }
	
	bool hasElement(BString const& name) const;
	
	std::list<HttpHeaderElement>& elements() {
		return m_elements;
	}
	
	std::list<HttpHeaderElement> const& elements() const {
		return m_elements;
	}
	
	HttpHeaderElement const* getFirstElement() const {
		return empty() ? 0 : &m_elements.front();
	}
	
	HttpHeaderElement const* getLastElement() const {
		return empty() ? 0 : &m_elements.back();
	}
	
	void appendElement(HttpHeaderElement const& el) {
		m_elements.push_back(el);
	}
	
	void prependElement(HttpHeaderElement const& el) {
		m_elements.push_front(el);
	}
	
	void removeElementsByName(BString const& name);
	
	void clear() { m_elements.clear(); }
	
	void toStream(std::ostream& strm) const;
	
	void commitChanges(HttpHeader& hdr);
private:
	typedef std::list<HttpHeaderElement> ElementList;
	typedef std::list<HttpHeaderElement::Param> ParamList;
	
	class Loader;
	
	static void printValue(std::ostream& strm, BString const& str);
	
	static bool isQuotingRequired(BString const& str);
	
	static void printQuoted(std::ostream& strm, BString const& str);
	
	ElementList m_elements;
};

#endif
