/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPHEADERSCOLLECTION_H_
#define HTTPHEADERSCOLLECTION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpHeader.h"
#include "InsensitiveLess.h"
#include "BString.h"
#include <map>
#include <iosfwd>

class HttpHeadersCollection
{
public:
	void addHeader(BString const& name, BString const& value);
	
	void setHeader(HttpHeader const& header);
	
	void setHeader(BString const& name, BString const& value);
	
	HttpHeader getHeader(BString const& name) const;
	
	HttpHeader *getHeaderPtr(BString const& name);
	
	HttpHeader const* getHeaderPtr(BString const& name) const;
	
	void removeHeader(BString const& name);
	
	bool hasHeader(BString const& name) const;
	
	void clear() { m_headers.clear(); }
	
	void toStream(std::ostream& strm) const;
	
	/**
	 * \brief Iterate over stored HttpHeader objects.
	 *
	 * The \p func argument is a function or a functor that can be
	 * called like this: func((HttpHeader const&)obj).
	 * \note \p func must not modify the HttpHeadersCollection it's
	 * iterating over.
	 */
	template<typename T>
	void foreach(T func) const;
private:
	typedef std::map<BString, HttpHeader, InsensitiveLess> HeaderMap;
	HeaderMap m_headers;
};

inline std::ostream&
operator<<(std::ostream& strm, HttpHeadersCollection const& collection)
{
	collection.toStream(strm);
	return strm;
}

template<typename T>
void
HttpHeadersCollection::foreach(T func) const
{
	HeaderMap::const_iterator it(m_headers.begin());
	HeaderMap::const_iterator const end(m_headers.end());
	for (; it != end; ++it) {
		func(it->second);
	}
}

#endif
