/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SOCKS5ASYNCCONNECTOR_H_
#define SOCKS5ASYNCCONNECTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "EventHandler.h"
#include "Reactor.h"
#include "Observer.h"
#include "Socks5Authenticator.h"
#include "Socks5Requester.h"
#include "SymbolicInetAddr.h"
#include "AutoClosingSAP.h"
#include <ace/config-lite.h>
#include <ace/SOCK_Stream.h>
#include <string>

class TimeDelta;
class SocksError;
class SocksConnectorListener;

namespace BuggyMsvcWorkaround {
typedef Socks5Authenticator::Listener  Socks5AuthenticatorListener;
typedef Socks5Requester::Listener Socks5RequesterListener;
}

class Socks5AsyncConnector :
	private EventHandlerBase,
	private BuggyMsvcWorkaround::Socks5AuthenticatorListener,
	private BuggyMsvcWorkaround::Socks5RequesterListener
{
	DECLARE_NON_COPYABLE(Socks5AsyncConnector)
public:
	typedef SocksConnectorListener Listener;
	
	Socks5AsyncConnector();
	
	virtual ~Socks5AsyncConnector();
	
	bool isInProgress() const { return m_state != ST_INACTIVE; }
	
	void initiate(Listener& listener, Reactor& reactor,
		AutoClosingSAP<ACE_SOCK_Stream>& proxy_conn,
		SymbolicInetAddr const& target_addr,
		std::string const& username, std::string const& password,
		TimeDelta const* timeout = 0);
	
	void abort();
private:
	enum State {
		ST_INACTIVE,
		ST_AUTHENTICATING,
		ST_REQUESTING_CONNECTION
	};
	
	virtual void ref();
	
	virtual void unref();
	
	virtual void handleTimeout(ReactorTimerId const& timer_id);
	
	virtual void onAuthSuccess();
	
	virtual void onAuthFailure(SocksError const& err);
	
	virtual void onRequestSuccess();
	
	virtual void onRequestFailure(SocksError const& err);
	
	void unregisterTimer();
	
	void handleConnectFailure(SocksError const& err);
	
	SingleObserverLink<Listener> m_observerLink;
	State m_state;
	int m_refCount;
	AutoClosingSAP<ACE_SOCK_Stream> m_proxyConn;
	SymbolicInetAddr m_targetAddr;
	Reactor* m_pReactor;
	ReactorTimerId m_timeoutTimerId;
	Socks5Authenticator m_authenticator;
	Socks5Requester m_requester;
};

#endif
