/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TIMER_H_
#define TIMER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "Reactor.h"
#include "EventHandler.h"
#include "TimeDelta.h"
#include <ace/config-lite.h>
#include <sigc++/sigc++.h>

class Timer : private EventHandlerBase
{
	DECLARE_NON_COPYABLE(Timer)
public:
	// The initial state is inactive.
	Timer(sigc::slot<void> const& callback,
		TimeDelta const& delay, Reactor* reactor = 0);
	
	~Timer();
	
	// Note: reactor and timer must not be used by different threads
	void connectToReactor(Reactor& reactor);
	
	void disconnectFromReactor();
	
	bool isConnectedToReactor() const { return m_pReactor != 0; }
	
	bool isActive() const { return m_isActive; }
	
	void deactivate();
	
	void reactivate();
	
	void postpone() { if (m_isActive) reactivate(); }
	
	void ensureActive() { if (!m_isActive) reactivate(); }
private:
	virtual void handleTimeout(ReactorTimerId const&);
	
	virtual void ref();
	
	virtual void unref();
	
	Reactor* m_pReactor;
	int m_refCounter; // must come before m_id
	sigc::slot<void> m_callback;
	TimeDelta m_delay;
	ReactorTimerId m_id;
	bool m_isActive;
};

#endif
